/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.stitch.datasource.impl;

import org.duracloud.client.ContentStore;
import org.duracloud.domain.Content;
import org.duracloud.error.ContentStoreException;
import org.duracloud.stitch.datasource.DataSource;
import org.duracloud.stitch.error.DataSourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuraStoreDataSource
implements DataSource {
    private Logger log = LoggerFactory.getLogger(DuraStoreDataSource.class);
    private ContentStore store;

    public DuraStoreDataSource(ContentStore store) {
        this.store = store;
    }

    @Override
    public Content getContent(String spaceId, String contentId) {
        this.log.debug("getContent({}, {})", (Object)spaceId, (Object)contentId);
        try {
            return this.store.getContent(spaceId, contentId);
        }
        catch (ContentStoreException e) {
            String msg = "Error getting content: " + e.getMessage();
            this.log.error(msg);
            throw new DataSourceException(msg, e);
        }
    }
}

