/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.mgmt;

import java.io.File;
import java.util.Date;
import org.duracloud.sync.endpoint.SyncResultType;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class SyncSummary {
    private String filename;
    private String absolutePath;
    private long length;
    private Date start;
    private Date stop;
    private String message;
    private SyncResultType type;

    public SyncSummary(File file, Date start, Date stop, SyncResultType type, String message) {
        this.filename = file.getName();
        this.absolutePath = file.getAbsolutePath();
        this.length = file.length();
        this.type = type;
        this.start = start;
        this.stop = stop;
        this.message = message;
    }

    public String getDurationAsString() {
        long duration = this.stop.getTime() - this.start.getTime();
        PeriodFormatter daysHoursMinutes = new PeriodFormatterBuilder().appendDays().appendSuffix(" day", " days").appendSeparator(" ").appendMinutes().appendSuffix(" min", " min").appendSeparator(" ").appendSeconds().appendSuffix(" sec", " secs").toFormatter();
        Period period = new Period(duration);
        return daysHoursMinutes.print(period);
    }

    public Date getStart() {
        return this.start;
    }

    public Date getStop() {
        return this.stop;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public long getLength() {
        return this.length;
    }

    public SyncResultType getType() {
        return this.type;
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

