/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.duracloud.common.model.Credential;
import org.duracloud.common.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestHttpHelper {
    protected final Logger log = LoggerFactory.getLogger(RestHttpHelper.class);
    private static final String XML_MIMETYPE = "text/xml";
    private Map<String, String> authHeaders = new HashMap<String, String>();

    public RestHttpHelper() {
        this(null);
    }

    public RestHttpHelper(Credential credential) {
        if (credential != null) {
            UsernamePasswordCredentials authCred = new UsernamePasswordCredentials(credential.getUsername(), credential.getPassword());
            String authHeaderVal = BasicScheme.authenticate(authCred, "utf-8");
            String authHeaderName = "Authorization";
            this.authHeaders.put(authHeaderName, authHeaderVal);
        }
    }

    public HttpResponse get(String url) throws Exception {
        return this.executeRequest(url, Method.GET, null, null);
    }

    public HttpResponse head(String url) throws Exception {
        return this.executeRequest(url, Method.HEAD, null, null);
    }

    public HttpResponse delete(String url) throws Exception {
        return this.executeRequest(url, Method.DELETE, null, null);
    }

    public HttpResponse post(String url, String requestContent, Map<String, String> headers) throws Exception {
        String mimeType = null;
        InputStreamRequestEntity requestEntity = this.buildInputStreamRequestEntity(requestContent, mimeType);
        return this.executeRequest(url, Method.POST, requestEntity, headers);
    }

    public HttpResponse post(String url, String requestContent, String mimeType, Map<String, String> headers) throws Exception {
        InputStreamRequestEntity requestEntity = this.buildInputStreamRequestEntity(requestContent, mimeType);
        return this.executeRequest(url, Method.POST, requestEntity, headers);
    }

    public HttpResponse post(String url, InputStream requestContent, String contentSize, String mimeType, Map<String, String> headers) throws Exception {
        long contentLength = Long.parseLong(contentSize);
        InputStreamRequestEntity requestEntity = this.buildInputStreamRequestEntity(requestContent, contentLength, mimeType);
        return this.executeRequest(url, Method.POST, requestEntity, headers);
    }

    public HttpResponse put(String url, String requestContent, Map<String, String> headers) throws Exception {
        String mimeType = null;
        InputStreamRequestEntity requestEntity = this.buildInputStreamRequestEntity(requestContent, mimeType);
        return this.executeRequest(url, Method.PUT, requestEntity, headers);
    }

    public HttpResponse put(String url, String requestContent, String mimeType, Map<String, String> headers) throws Exception {
        InputStreamRequestEntity requestEntity = this.buildInputStreamRequestEntity(requestContent, mimeType);
        return this.executeRequest(url, Method.PUT, requestEntity, headers);
    }

    public HttpResponse put(String url, InputStream requestContent, String contentSize, String mimeType, Map<String, String> headers) throws Exception {
        long contentLength = Long.parseLong(contentSize);
        InputStreamRequestEntity requestEntity = this.buildInputStreamRequestEntity(requestContent, contentLength, mimeType);
        return this.executeRequest(url, Method.PUT, requestEntity, headers);
    }

    public HttpResponse multipartFilePost(String url, File file) throws Exception {
        Part[] parts = new Part[]{new FilePart(file.getName(), file)};
        return this.multipartPost(url, parts);
    }

    public HttpResponse multipartFileStreamPost(String url, String fileName, InputStream stream, long length) throws Exception {
        Part[] parts = new Part[]{new FilePart(fileName, new StreamPart(fileName, stream, length))};
        return this.multipartPost(url, parts);
    }

    public HttpResponse multipartPost(String url, Part[] parts) throws Exception {
        Map<String, String> headers = null;
        RequestEntity re = this.buildMultipartRequestEntity(url, parts);
        return this.executeRequest(url, Method.MULTPART, re, headers);
    }

    private InputStreamRequestEntity buildInputStreamRequestEntity(String requestContent, String argMimeType) throws Exception {
        if (requestContent == null) {
            return null;
        }
        InputStream streamContent = IOUtil.writeStringToStream(requestContent);
        long contentLength = requestContent.length();
        return this.buildInputStreamRequestEntity(streamContent, contentLength, argMimeType);
    }

    private InputStreamRequestEntity buildInputStreamRequestEntity(InputStream streamContent, long contentLength, String argMimeType) throws Exception {
        if (streamContent == null) {
            return null;
        }
        String mimeType = argMimeType == null ? XML_MIMETYPE : argMimeType;
        return new InputStreamRequestEntity(streamContent, contentLength, mimeType);
    }

    private RequestEntity buildMultipartRequestEntity(String url, Part[] parts) {
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("URL must be a non-empty value");
        }
        if (parts == null || parts.length == 0) {
            return null;
        }
        PostMethod postMethod = new PostMethod(url);
        return new MultipartRequestEntity(parts, postMethod.getParams());
    }

    private HttpResponse executeRequest(String url, Method method, RequestEntity requestEntity, Map<String, String> headers) throws Exception {
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("URL must be a non-empty value");
        }
        HttpMethod httpMethod = method.getMethod(url, requestEntity);
        if (this.authHeaders != null && this.authHeaders.size() > 0) {
            this.addHeaders(httpMethod, this.authHeaders);
        }
        if (headers != null && headers.size() > 0) {
            this.addHeaders(httpMethod, headers);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.loggingRequestText(url, method, requestEntity, headers));
        }
        HttpClient client = new HttpClient();
        client.executeMethod(httpMethod);
        HttpResponse response = new HttpResponse(httpMethod);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.loggingResponseText(response));
        }
        return response;
    }

    private void addHeaders(HttpMethod httpMethod, Map<String, String> headers) {
        for (String headerName : headers.keySet()) {
            String headerValue = headers.get(headerName);
            if (headerName == null || headerValue == null) continue;
            httpMethod.addRequestHeader(headerName, headerValue);
        }
    }

    private String loggingRequestText(String url, Method method, RequestEntity requestEntity, Map<String, String> headers) {
        StringBuilder sb = new StringBuilder("URL: '" + url + "'\n");
        if (method != null) {
            sb.append("METHOD: '" + method.name() + "'\n");
        }
        if (requestEntity != null) {
            sb.append("CONTENT-TYPE: '" + requestEntity.getContentType() + "'\n");
        }
        if (headers != null && headers.size() > 0) {
            sb.append("HEADERS: \n");
            for (String key : headers.keySet()) {
                sb.append("  [" + key + "|" + headers.get(key) + "]\n");
            }
        }
        return sb.toString();
    }

    private String loggingResponseText(HttpResponse response) {
        Header[] footers;
        StringBuilder sb = new StringBuilder();
        sb.append("RESPONSE CODE: '" + response.getStatusCode() + "'\n");
        Header[] headers = response.getResponseHeaders();
        if (headers != null && headers.length > 0) {
            sb.append("RESPONSE HEADERS: \n");
            for (Header header : headers) {
                sb.append("  [" + header.getName() + "|" + header.getValue() + "]\n");
            }
        }
        if ((footers = response.getResponseFooters()) != null && footers.length > 0) {
            sb.append("RESPONSE FOOTERS: \n");
            for (Header footer : footers) {
                sb.append("  [" + footer.getName() + "|" + footer.getValue() + "]\n");
            }
        }
        return sb.toString();
    }

    public static class HttpResponse {
        private final int statusCode;
        private final InputStream responseStream;
        private final Header[] responseHeaders;
        private final Header[] responseFooters;
        private HttpMethod httpMethod;

        public HttpResponse(int statusCode, Header[] responseHeaders, Header[] responseFooters, InputStream responseStream) {
            this.statusCode = statusCode;
            this.responseHeaders = responseHeaders;
            this.responseFooters = responseFooters;
            this.responseStream = responseStream;
        }

        public HttpResponse(HttpMethod method) throws IOException {
            this(method.getStatusCode(), method.getResponseHeaders(), method.getResponseFooters(), method.getResponseBodyAsStream());
            this.httpMethod = method;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public InputStream getResponseStream() {
            return this.responseStream;
        }

        public String getResponseBody() throws IOException {
            if (this.responseStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.responseStream, "UTF-8"));
                StringBuilder builder = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                this.responseStream.close();
                return builder.toString();
            }
            return null;
        }

        public Header[] getResponseHeaders() {
            return this.responseHeaders;
        }

        public Header[] getResponseFooters() {
            return this.responseFooters;
        }

        public Header getResponseHeader(String headerName) {
            for (Header header : this.responseHeaders) {
                if (!header.getName().equalsIgnoreCase(headerName)) continue;
                return header;
            }
            return null;
        }

        public void close() {
            if (null != this.httpMethod) {
                this.httpMethod.releaseConnection();
            }
        }
    }

    private class StreamPart
    implements PartSource {
        private String fileName;
        private InputStream stream;
        private long length;

        public StreamPart(String fileName, InputStream stream, long length) {
            this.fileName = fileName;
            this.stream = stream;
            this.length = length;
        }

        @Override
        public InputStream createInputStream() throws IOException {
            return this.stream;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public long getLength() {
            return this.length;
        }
    }

    private static enum Method {
        GET{

            @Override
            public HttpMethod getMethod(String url, RequestEntity re) {
                return new GetMethod(url);
            }
        }
        ,
        POST{

            @Override
            public HttpMethod getMethod(String url, RequestEntity re) {
                PostMethod postMethod = new PostMethod(url);
                if (re != null) {
                    String length = String.valueOf(re.getContentLength());
                    postMethod.setRequestHeader("Content-Length", length);
                    postMethod.setRequestEntity(re);
                }
                return postMethod;
            }
        }
        ,
        PUT{

            @Override
            public HttpMethod getMethod(String url, RequestEntity re) {
                PutMethod putMethod = new PutMethod(url);
                if (re != null) {
                    putMethod.setRequestEntity(re);
                }
                return putMethod;
            }
        }
        ,
        MULTPART{

            @Override
            public HttpMethod getMethod(String url, RequestEntity re) {
                PostMethod postMethod = new PostMethod(url);
                if (re != null) {
                    String length = String.valueOf(re.getContentLength());
                    postMethod.setRequestHeader("Content-Length", length);
                    postMethod.setRequestEntity(re);
                }
                return postMethod;
            }
        }
        ,
        HEAD{

            @Override
            public HttpMethod getMethod(String url, RequestEntity re) {
                return new HeadMethod(url);
            }
        }
        ,
        DELETE{

            @Override
            public HttpMethod getMethod(String url, RequestEntity re) {
                return new DeleteMethod(url);
            }
        };


        public abstract HttpMethod getMethod(String var1, RequestEntity var2);
    }
}

