/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.domain;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.duracloud.storage.provider.StorageProvider;

public class ContentIterator
implements Iterator<String> {
    private StorageProvider provider;
    private String spaceId;
    private String prefix;
    private int index = 0;
    private List<String> contentList;
    private long maxResults;

    public ContentIterator(StorageProvider provider, String spaceId, String prefix) {
        this(provider, spaceId, prefix, 10000L);
    }

    public ContentIterator(StorageProvider provider, String spaceId, String prefix, long maxResults) {
        this.provider = provider;
        this.spaceId = spaceId;
        this.prefix = prefix;
        this.maxResults = maxResults;
        this.contentList = provider.getSpaceContentsChunked(spaceId, prefix, maxResults, null);
    }

    @Override
    public boolean hasNext() {
        if (this.index < this.contentList.size()) {
            return true;
        }
        if (this.contentList.size() > 0) {
            this.updateList();
            return this.contentList.size() > 0;
        }
        return false;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            String next = this.contentList.get(this.index);
            ++this.index;
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void updateList() {
        String lastItem = this.contentList.get(this.contentList.size() - 1);
        this.contentList = this.provider.getSpaceContentsChunked(this.spaceId, this.prefix, this.maxResults, lastItem);
        this.index = 0;
    }
}

