/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.AssociatedInstancesException;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationAlreadyExistsException;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationDoesNotExistException;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationLimitExceededException;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentAlreadyExistsException;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentLimitExceededException;
import com.amazonaws.services.simplesystemsmanagement.model.DuplicateInstanceIdException;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.InternalServerErrorException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidDocumentContentException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidDocumentException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidInstanceIdException;
import com.amazonaws.services.simplesystemsmanagement.model.InvalidNextTokenException;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsResult;
import com.amazonaws.services.simplesystemsmanagement.model.MaxDocumentSizeExceededException;
import com.amazonaws.services.simplesystemsmanagement.model.StatusUnchangedException;
import com.amazonaws.services.simplesystemsmanagement.model.TooManyUpdatesException;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusRequest;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusResult;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationBatchRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationBatchResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateAssociationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CreateDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteAssociationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteAssociationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DeleteDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeAssociationRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeAssociationResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DescribeDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.GetDocumentRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.GetDocumentResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListAssociationsRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListDocumentsRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.ListDocumentsResultJsonUnmarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.UpdateAssociationStatusRequestMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.UpdateAssociationStatusResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSSimpleSystemsManagementClient
extends AmazonWebServiceClient
implements AWSSimpleSystemsManagement {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSimpleSystemsManagement.class);
    private static final String DEFAULT_SIGNING_NAME = "ssm";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSSimpleSystemsManagementClient() {
        this(new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AWSSimpleSystemsManagementClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSSimpleSystemsManagementClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSSimpleSystemsManagementClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSSimpleSystemsManagementClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSSimpleSystemsManagementClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSSimpleSystemsManagementClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidDocumentContentException.class, "InvalidDocumentContent"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AssociationDoesNotExistException.class, "AssociationDoesNotExist"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidNextTokenException.class, "InvalidNextToken"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(TooManyUpdatesException.class, "TooManyUpdates"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AssociatedInstancesException.class, "AssociatedInstances"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalServerErrorException.class, "InternalServerError"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AssociationLimitExceededException.class, "AssociationLimitExceeded"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(DuplicateInstanceIdException.class, "DuplicateInstanceId"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MaxDocumentSizeExceededException.class, "MaxDocumentSizeExceeded"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AssociationAlreadyExistsException.class, "AssociationAlreadyExists"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidInstanceIdException.class, "InvalidInstanceId"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidDocumentException.class, "InvalidDocument"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(DocumentAlreadyExistsException.class, "DocumentAlreadyExists"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(DocumentLimitExceededException.class, "DocumentLimitExceeded"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(StatusUnchangedException.class, "StatusUnchanged"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setEndpoint("https://ssm.us-east-1.amazonaws.com");
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simplesystemsmanagement/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simplesystemsmanagement/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssociationResult createAssociation(CreateAssociationRequest createAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssociationRequest> request = null;
        Response<CreateAssociationResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssociationRequestMarshaller().marshall(createAssociationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new CreateAssociationResultJsonUnmarshaller(), executionContext);
            CreateAssociationResult createAssociationResult = response.getAwsResponse();
            return createAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssociationBatchResult createAssociationBatch(CreateAssociationBatchRequest createAssociationBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssociationBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssociationBatchRequest> request = null;
        Response<CreateAssociationBatchResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssociationBatchRequestMarshaller().marshall(createAssociationBatchRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new CreateAssociationBatchResultJsonUnmarshaller(), executionContext);
            CreateAssociationBatchResult createAssociationBatchResult = response.getAwsResponse();
            return createAssociationBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDocumentResult createDocument(CreateDocumentRequest createDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDocumentRequest> request = null;
        Response<CreateDocumentResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDocumentRequestMarshaller().marshall(createDocumentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new CreateDocumentResultJsonUnmarshaller(), executionContext);
            CreateDocumentResult createDocumentResult = response.getAwsResponse();
            return createDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssociationResult deleteAssociation(DeleteAssociationRequest deleteAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssociationRequest> request = null;
        Response<DeleteAssociationResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssociationRequestMarshaller().marshall(deleteAssociationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new DeleteAssociationResultJsonUnmarshaller(), executionContext);
            DeleteAssociationResult deleteAssociationResult = response.getAwsResponse();
            return deleteAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDocumentResult deleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDocumentRequest> request = null;
        Response<DeleteDocumentResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDocumentRequestMarshaller().marshall(deleteDocumentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new DeleteDocumentResultJsonUnmarshaller(), executionContext);
            DeleteDocumentResult deleteDocumentResult = response.getAwsResponse();
            return deleteDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssociationResult describeAssociation(DescribeAssociationRequest describeAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssociationRequest> request = null;
        Response<DescribeAssociationResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssociationRequestMarshaller().marshall(describeAssociationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new DescribeAssociationResultJsonUnmarshaller(), executionContext);
            DescribeAssociationResult describeAssociationResult = response.getAwsResponse();
            return describeAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDocumentResult describeDocument(DescribeDocumentRequest describeDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDocumentRequest> request = null;
        Response<DescribeDocumentResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDocumentRequestMarshaller().marshall(describeDocumentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new DescribeDocumentResultJsonUnmarshaller(), executionContext);
            DescribeDocumentResult describeDocumentResult = response.getAwsResponse();
            return describeDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDocumentResult getDocument(GetDocumentRequest getDocumentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDocumentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDocumentRequest> request = null;
        Response<GetDocumentResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDocumentRequestMarshaller().marshall(getDocumentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetDocumentResultJsonUnmarshaller(), executionContext);
            GetDocumentResult getDocumentResult = response.getAwsResponse();
            return getDocumentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssociationsResult listAssociations(ListAssociationsRequest listAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssociationsRequest> request = null;
        Response<ListAssociationsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssociationsRequestMarshaller().marshall(listAssociationsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListAssociationsResultJsonUnmarshaller(), executionContext);
            ListAssociationsResult listAssociationsResult = response.getAwsResponse();
            return listAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDocumentsResult listDocuments(ListDocumentsRequest listDocumentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDocumentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDocumentsRequest> request = null;
        Response<ListDocumentsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDocumentsRequestMarshaller().marshall(listDocumentsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListDocumentsResultJsonUnmarshaller(), executionContext);
            ListDocumentsResult listDocumentsResult = response.getAwsResponse();
            return listDocumentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDocumentsResult listDocuments() {
        return this.listDocuments(new ListDocumentsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAssociationStatusResult updateAssociationStatus(UpdateAssociationStatusRequest updateAssociationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAssociationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAssociationStatusRequest> request = null;
        Response<UpdateAssociationStatusResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAssociationStatusRequestMarshaller().marshall(updateAssociationStatusRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new UpdateAssociationStatusResultJsonUnmarshaller(), executionContext);
            UpdateAssociationStatusResult updateAssociationStatusResult = response.getAwsResponse();
            return updateAssociationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, JsonUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonResponseHandler<X> responseHandler = new JsonResponseHandler<X>(unmarshaller);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

