/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.BackoffThrottler;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynchronousRetrier {
    private static final Log log = LogFactory.getLog(SynchronousRetrier.class);
    private final ExponentialRetryParameters retryParameters;
    private final Class<?>[] exceptionsToNotRetry;

    public SynchronousRetrier(ExponentialRetryParameters retryParameters, Class<?> ... exceptionsToNotRetry) {
        if (retryParameters.getBackoffCoefficient() < 0.0) {
            throw new IllegalArgumentException("negative backoffCoefficient");
        }
        if (retryParameters.getInitialInterval() < 10L) {
            throw new IllegalArgumentException("initialInterval cannot be less then 10: " + retryParameters.getInitialInterval());
        }
        if (retryParameters.getExpirationInterval() < retryParameters.getInitialInterval()) {
            throw new IllegalArgumentException("expirationInterval < initialInterval");
        }
        if (retryParameters.getMaximumRetries() < retryParameters.getMinimumRetries()) {
            throw new IllegalArgumentException("maximumRetries < minimumRetries");
        }
        this.retryParameters = retryParameters;
        this.exceptionsToNotRetry = exceptionsToNotRetry;
    }

    public ExponentialRetryParameters getRetryParameters() {
        return this.retryParameters;
    }

    public Class<?>[] getExceptionsToNotRetry() {
        return this.exceptionsToNotRetry;
    }

    /*
     * Unable to fully structure code
     */
    public void retry(Runnable r) {
        attempt = 0;
        startTime = System.currentTimeMillis();
        throttler = new BackoffThrottler(this.retryParameters.getInitialInterval(), this.retryParameters.getMaximumRetryInterval(), this.retryParameters.getBackoffCoefficient());
        success = false;
        do {
            try {
                ++attempt;
                throttler.throttle();
                r.run();
                success = true;
                throttler.success();
                continue;
            }
            catch (InterruptedException v0) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (RuntimeException e) {
                throttler.failure();
                var11_11 = this.exceptionsToNotRetry;
                var10_10 = this.exceptionsToNotRetry.length;
                var9_9 = 0;
                ** while (var9_9 < var10_10)
            }
lbl-1000:
            // 1 sources

            {
                exceptionToNotRetry = var11_11[var9_9];
                if (exceptionToNotRetry.isAssignableFrom(e.getClass())) {
                    throw e;
                }
                ++var9_9;
                continue;
            }
lbl27:
            // 1 sources

            elapsed = System.currentTimeMillis() - startTime;
            if (attempt > this.retryParameters.getMaximumRetries() || elapsed >= this.retryParameters.getExpirationInterval() && attempt > this.retryParameters.getMinimumRetries()) {
                throw e;
            }
            SynchronousRetrier.log.warn("Retrying after failure", e);
        } while (!success);
    }
}

