/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVolumeRequestMarshaller
implements Marshaller<Request<CreateVolumeRequest>, CreateVolumeRequest> {
    @Override
    public Request<CreateVolumeRequest> marshall(CreateVolumeRequest createVolumeRequest) {
        if (createVolumeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVolumeRequest> request = new DefaultRequest<CreateVolumeRequest>(createVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVolume");
        request.addParameter("Version", "2015-04-15");
        if (createVolumeRequest.getSize() != null) {
            request.addParameter("Size", StringUtils.fromInteger(createVolumeRequest.getSize()));
        }
        if (createVolumeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString(createVolumeRequest.getSnapshotId()));
        }
        if (createVolumeRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(createVolumeRequest.getAvailabilityZone()));
        }
        if (createVolumeRequest.getVolumeType() != null) {
            request.addParameter("VolumeType", StringUtils.fromString(createVolumeRequest.getVolumeType()));
        }
        if (createVolumeRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger(createVolumeRequest.getIops()));
        }
        if (createVolumeRequest.isEncrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean(createVolumeRequest.isEncrypted()));
        }
        if (createVolumeRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(createVolumeRequest.getKmsKeyId()));
        }
        return request;
    }
}

