/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.model;

import org.duracloud.common.model.Credential;
import org.duracloud.common.util.ChecksumUtil;

public class RootUserCredential
extends Credential {
    private static final String defaultUsername = "root";
    private static final String defaultPassword = "rpw";
    private static final String defaultEmail = "no-root-password-set";

    public RootUserCredential() {
        super(RootUserCredential.getRootUsername(), RootUserCredential.getRootPassword());
    }

    public static String getRootUsername() {
        return System.getProperty("root.username", defaultUsername);
    }

    public static String getRootEmail() {
        return System.getProperty("root.email", defaultEmail);
    }

    private static String getRootPassword() {
        return System.getProperty("root.password", defaultPassword);
    }

    public String getRootEncodedPassword() {
        ChecksumUtil util = new ChecksumUtil(ChecksumUtil.Algorithm.SHA_256);
        return util.generateChecksum(RootUserCredential.getRootPassword());
    }
}

