/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.provider;

import java.util.ArrayList;
import java.util.List;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.TaskProvider;
import org.duracloud.storage.provider.TaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskProviderBase
implements TaskProvider {
    protected Logger log = LoggerFactory.getLogger(TaskProviderBase.class);
    protected List<TaskRunner> taskList = new ArrayList<TaskRunner>();

    @Override
    public List<String> getSupportedTasks() {
        this.log.debug("getSupportedTasks()");
        ArrayList<String> supportedTasks = new ArrayList<String>();
        for (TaskRunner runner : this.taskList) {
            supportedTasks.add(runner.getName());
        }
        return supportedTasks;
    }

    @Override
    public String performTask(String taskName, String taskParameters) {
        this.log.debug("performTask(" + taskName + ", " + taskParameters + ")");
        for (TaskRunner runner : this.taskList) {
            if (!runner.getName().equals(taskName)) continue;
            return runner.performTask(taskParameters);
        }
        throw new UnsupportedTaskException(taskName);
    }
}

