/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.stitch.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.manifest.ChunksManifestBean;
import org.duracloud.chunk.manifest.xml.ManifestDocumentBinding;
import org.duracloud.common.model.ContentItem;
import org.duracloud.domain.Content;
import org.duracloud.stitch.FileStitcher;
import org.duracloud.stitch.datasource.DataSource;
import org.duracloud.stitch.error.InvalidManifestException;
import org.duracloud.stitch.stream.MultiContentInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStitcherImpl
implements FileStitcher {
    private Logger log = LoggerFactory.getLogger(FileStitcherImpl.class);
    private DataSource dataSource;

    public FileStitcherImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Content getContentFromManifest(String spaceId, String contentId) throws InvalidManifestException {
        this.log.debug("getContentFromManifest({}, {})", (Object)spaceId, (Object)contentId);
        if (!this.isManifest(contentId)) {
            this.log.error("Invalid manifest name: {}", (Object)contentId);
            throw new InvalidManifestException(spaceId, contentId);
        }
        ChunksManifest manifest = this.getManifest(spaceId, contentId);
        InputStream multiStream = this.getChunkSequenceStream(spaceId, manifest);
        Content content = new Content();
        content.setStream(multiStream);
        content.setId(manifest.getHeader().getSourceContentId());
        content.setProperties(this.getContentProperties(manifest));
        return content;
    }

    private boolean isManifest(String contentId) {
        return null != contentId && contentId.endsWith(".dura-manifest");
    }

    @Override
    public ChunksManifest getManifest(String spaceId, String manifestId) throws InvalidManifestException {
        Content content = this.dataSource.getContent(spaceId, manifestId);
        if (null == content) {
            String msg = "No content found!";
            this.log.error(msg);
            throw new InvalidManifestException(spaceId, manifestId, msg);
        }
        try {
            return ManifestDocumentBinding.createManifestFrom(content.getStream());
        }
        catch (Exception e) {
            String msg = "Error deserializing manifest!";
            this.log.error(msg);
            throw new InvalidManifestException(spaceId, manifestId, msg, e);
        }
    }

    private InputStream getChunkSequenceStream(String spaceId, ChunksManifest manifest) throws InvalidManifestException {
        TreeMap<Integer, String> sortedChunkIds = new TreeMap<Integer, String>();
        for (ChunksManifestBean.ManifestEntry manifestEntry : manifest.getEntries()) {
            sortedChunkIds.put(manifestEntry.getIndex(), manifestEntry.getChunkId());
        }
        ArrayList<ContentItem> chunks = new ArrayList<ContentItem>();
        for (String chunkId : sortedChunkIds.values()) {
            chunks.add(new ContentItem(spaceId, chunkId));
        }
        if (chunks.size() == 0) {
            String string = "No chunk streams found!";
            this.log.error(string);
            String contentId = manifest.getHeader().getSourceContentId();
            throw new InvalidManifestException(spaceId, contentId, string);
        }
        return new MultiContentInputStream(this.dataSource, chunks);
    }

    private Map<String, String> getContentProperties(ChunksManifest manifest) {
        HashMap<String, String> props = new HashMap<String, String>();
        ChunksManifestBean.ManifestHeader header = manifest.getHeader();
        String contentSize = Long.toString(header.getSourceByteSize());
        props.put("content-size", contentSize);
        props.put("content-mimetype", header.getSourceMimetype());
        props.put("content-md5", header.getSourceMD5());
        props.put("content-checksum", header.getSourceMD5());
        return props;
    }
}

