/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.walker;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.duracloud.sync.walker.DirWalker;

public class RestartDirWalker
extends DirWalker {
    private long lastBackup;
    private List<File> changedDirs;
    private File excludeFile;

    protected RestartDirWalker(List<File> topDirs, File excludeFile, long lastBackup) {
        super(topDirs, excludeFile);
        this.excludeFile = excludeFile;
        this.lastBackup = lastBackup;
        this.changedDirs = new ArrayList<File>();
    }

    @Override
    protected void walkDirs() {
        super.walkDirs();
        if (this.changedDirs.size() > 0) {
            DirWalker dirWalker = new DirWalker(this.changedDirs, this.excludeFile);
            dirWalker.walkDirs();
        }
    }

    @Override
    protected void handleFile(File file, int depth, Collection results) {
        if (file.lastModified() > this.lastBackup) {
            super.handleFile(file, depth, results);
        }
    }

    protected boolean handleDirectory(File directory, int depth, Collection results) {
        if (directory.lastModified() > this.lastBackup) {
            this.changedDirs.add(directory);
        }
        return true;
    }

    public static DirWalker start(List<File> topDirs, File excludeFile, long lastBackup) {
        RestartDirWalker dirWalker = new RestartDirWalker(topDirs, excludeFile, lastBackup);
        new Thread(dirWalker).start();
        return dirWalker;
    }
}

