/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.model;

import org.duracloud.common.model.Credential;
import org.duracloud.common.util.ChecksumUtil;

public class RootUserCredential
extends Credential {
    private static final String defaultUsername = "root";
    private static final String defaultPassword = "rpw";

    public RootUserCredential() {
        super(RootUserCredential.getRootUsername(), RootUserCredential.getRootPassword());
    }

    public static String getRootUsername() {
        String username = System.getProperty("root.username");
        if (null == username) {
            username = defaultUsername;
        }
        return username;
    }

    private static String getRootPassword() {
        String password = System.getProperty("root.password");
        if (null == password) {
            password = defaultPassword;
        }
        return password;
    }

    public String getRootEncodedPassword() {
        ChecksumUtil util = new ChecksumUtil(ChecksumUtil.Algorithm.SHA_256);
        return util.generateChecksum(RootUserCredential.getRootPassword());
    }
}

