/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.spaces.controller;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.client.task.SnapshotTaskClient;
import org.duracloud.client.task.SnapshotTaskClientManager;
import org.duracloud.error.ContentStateException;
import org.duracloud.error.ContentStoreException;
import org.duracloud.security.DuracloudUserDetailsService;
import org.duracloud.snapshot.dto.SnapshotHistoryItem;
import org.duracloud.snapshot.dto.task.CreateSnapshotTaskResult;
import org.duracloud.snapshot.dto.task.GetSnapshotContentsTaskResult;
import org.duracloud.snapshot.dto.task.GetSnapshotHistoryTaskResult;
import org.duracloud.snapshot.id.SnapshotIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SnapshotController {
    protected final Logger log = LoggerFactory.getLogger(SnapshotController.class);
    private ContentStoreManager contentStoreManager;
    private DuracloudUserDetailsService userDetailsService;
    private SnapshotTaskClientManager snapshotTaskClientManager;

    @Autowired(required=true)
    public SnapshotController(@Qualifier(value="contentStoreManager") ContentStoreManager contentStoreManager, @Qualifier(value="userDetailsSvc") DuracloudUserDetailsService userDetailsService, SnapshotTaskClientManager snapshotTaskClientManager) {
        this.contentStoreManager = contentStoreManager;
        this.userDetailsService = userDetailsService;
        this.snapshotTaskClientManager = snapshotTaskClientManager;
    }

    @RequestMapping(value={"/spaces/snapshot"}, method={RequestMethod.POST})
    @ResponseBody
    public String create(HttpServletRequest request, HttpServletResponse response, @RequestParam String spaceId, @RequestParam String storeId, @RequestParam String description) throws Exception {
        ContentStore store = this.getContentStore(storeId);
        response.setHeader("Content-Type", "application/json");
        if (this.isSnapshotInProgress(store, spaceId)) {
            response.setStatus(420);
            return "{\"result\":\"Snapshot already in progress.\"}";
        }
        String username = this.getUsername(request);
        String userEmail = this.getUserEmail(username);
        SnapshotTaskClient taskClient = this.getTaskClient(storeId);
        try {
            CreateSnapshotTaskResult result = taskClient.createSnapshot(spaceId, description, userEmail);
            response.setStatus(202);
            return result.serialize();
        }
        catch (ContentStateException ex) {
            response.setStatus(409);
            return ex.getMessage();
        }
    }

    protected String getUserEmail(String username) {
        String userEmail = this.userDetailsService.getUserByUsername(username).getEmail();
        return userEmail;
    }

    protected String getUsername(HttpServletRequest request) {
        String username = request.getUserPrincipal().getName();
        return username;
    }

    @RequestMapping(value={"/spaces/snapshot"}, method={RequestMethod.GET})
    public ModelAndView get(@RequestParam String storeId, @RequestParam String spaceId) {
        Properties props;
        block15: {
            props = new Properties();
            try {
                ContentStore store = this.contentStoreManager.getContentStore(storeId);
                if (!store.contentExists(spaceId, ".collection-snapshot.properties")) break block15;
                try (InputStream is = store.getContent(spaceId, ".collection-snapshot.properties").getStream();){
                    props.load(is);
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                props.put("error", "Snapshot properties could not be loaded: " + e.getMessage());
            }
        }
        ModelAndView mav = new ModelAndView("jsonView");
        for (Object key : props.keySet()) {
            mav.addObject(key.toString(), props.get(key));
        }
        return mav;
    }

    @RequestMapping(value={"/spaces/snapshots/{storeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getSnapshotList(@PathVariable(value="storeId") String storeId) {
        try {
            return this.getTaskClient(storeId).getSnapshots().serialize();
        }
        catch (ContentStoreException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/spaces/snapshots/{storeId}/{snapshotId:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getSnapshot(@PathVariable(value="storeId") String storeId, @PathVariable(value="snapshotId") String snapshotId) throws Exception {
        return this.getTaskClient(storeId).getSnapshot(snapshotId).serialize();
    }

    @RequestMapping(value={"/spaces/snapshots/{storeId}/{snapshotId}/history"}, method={RequestMethod.GET})
    public ModelAndView getHistory(@PathVariable(value="storeId") String storeId, @PathVariable(value="snapshotId") String snapshotId, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="attachment", required=false, defaultValue="false") Boolean attachment, HttpServletResponse response) {
        try {
            SnapshotTaskClient taskClient = this.getTaskClient(storeId);
            if (attachment.booleanValue()) {
                StringBuffer contentDisposition = new StringBuffer();
                contentDisposition.append("attachment;");
                contentDisposition.append("filename=\"");
                contentDisposition.append(snapshotId + ".history.json");
                contentDisposition.append("\"");
                response.setHeader("Content-Disposition", contentDisposition.toString());
            }
            if (page == null) {
                page = 0;
            }
            this.streamSnapshotHistory(page, storeId, snapshotId, taskClient, response);
            return null;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void streamSnapshotHistory(int page, String storeId, String snapshotId, SnapshotTaskClient taskClient, HttpServletResponse response) throws IOException, ContentStoreException {
        PrintWriter writer = response.getWriter();
        int pageSize = 200;
        if (page < 0) {
            pageSize = 1000;
        }
        int pageCounter = page;
        JsonFactory factory = new JsonFactory();
        JsonGenerator jwriter = factory.createJsonGenerator((Writer)writer);
        jwriter.writeStartObject();
        jwriter.writeFieldName("historyItems");
        jwriter.writeStartArray();
        GetSnapshotHistoryTaskResult result = null;
        while (true) {
            result = this.getSnapshotHistory(snapshotId, pageCounter, taskClient, pageSize);
            List items = result.getHistoryItems();
            for (SnapshotHistoryItem item : items) {
                jwriter.writeStartObject();
                jwriter.writeNumberField("historyDate", item.getHistoryDate().getTime());
                jwriter.writeStringField("history", item.getHistory());
                jwriter.writeEndObject();
            }
            if (items.size() < pageSize || page >= 0) break;
            ++pageCounter;
        }
        jwriter.writeEndArray();
        if (page >= 0) {
            jwriter.writeNumberField("page", page);
            jwriter.writeNumberField("totalCount", result.getTotalCount().longValue());
            if (result.getHistoryItems().size() == pageSize && (long)(page + 1 * pageSize) < result.getTotalCount()) {
                jwriter.writeNumberField("nextPage", page + 1);
            } else {
                jwriter.writeNullField("nextPage");
            }
        }
        jwriter.writeStringField("snapshotId", snapshotId);
        jwriter.writeStringField("storeId", storeId);
        jwriter.writeEndObject();
        jwriter.close();
    }

    protected GetSnapshotHistoryTaskResult getSnapshotHistory(String snapshotId, Integer page, SnapshotTaskClient taskClient, int pageSize) throws ContentStoreException {
        GetSnapshotHistoryTaskResult result = taskClient.getSnapshotHistory(snapshotId, page.intValue(), pageSize);
        List items = result.getHistoryItems();
        for (SnapshotHistoryItem item : items) {
            item.setHistory(item.getHistory().replaceAll("'", "\""));
        }
        return result;
    }

    @RequestMapping(value={"/spaces/snapshots/{storeId}/{snapshotId}/content"}, method={RequestMethod.GET})
    public ModelAndView getContent(@PathVariable(value="storeId") String storeId, @PathVariable(value="snapshotId") String snapshotId, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="prefix", required=false) String prefix) {
        try {
            SnapshotTaskClient taskClient = this.getTaskClient(storeId);
            if (page == null) {
                page = 0;
            }
            int pageSize = 200;
            GetSnapshotContentsTaskResult result = taskClient.getSnapshotContents(snapshotId, page.intValue(), pageSize, prefix);
            List items = result.getContentItems();
            ModelAndView mav = new ModelAndView("jsonView");
            mav.addObject("contents", (Object)items);
            mav.addObject("page", (Object)page);
            mav.addObject("snapshotId", (Object)snapshotId);
            mav.addObject("storeId", (Object)storeId);
            mav.addObject("nextPage", items.size() == pageSize ? Integer.valueOf(page + 1) : null);
            mav.addObject("prefix", (Object)prefix);
            mav.addObject("totalCount", (Object)result.getTotalCount());
            return mav;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/spaces/snapshots/{storeId}/{snapshotId}/restore-space-id"}, method={RequestMethod.GET})
    @ResponseBody
    public String restoreSpaceId(HttpServletRequest request, @PathVariable(value="storeId") String storeId, @PathVariable(value="snapshotId") String snapshotId) throws Exception {
        String spaceId;
        ContentStore contentStore = this.getContentStore(storeId);
        if (contentStore.spaceExists(spaceId = SnapshotIdentifier.parseSnapshotId((String)snapshotId).getRestoreSpaceId())) {
            return "{ \"spaceId\": \"" + spaceId + "\",\"storeId\": \"" + storeId + "\"}";
        }
        return "{}";
    }

    protected SnapshotTaskClient getTaskClient(String storeId) throws ContentStoreException {
        SnapshotTaskClient taskClient = this.snapshotTaskClientManager.get(storeId);
        return taskClient;
    }

    @RequestMapping(value={"/spaces/restores/{storeId}/by-snapshot/{snapshotId:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getRestore(@PathVariable(value="storeId") String storeId, @PathVariable(value="snapshotId") String snapshotId) {
        try {
            return this.getTaskClient(storeId).getRestoreBySnapshot(snapshotId).serialize();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/spaces/restores/{storeId}/{restoreId:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getRestoreByRestoreId(@PathVariable(value="storeId") String storeId, @PathVariable(value="restoreId") String restoreId) {
        try {
            return this.getTaskClient(storeId).getRestore(restoreId).serialize();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/spaces/restores"}, method={RequestMethod.POST})
    @ResponseBody
    public String restore(HttpServletRequest request, @RequestParam String storeId, @RequestParam String snapshotId) throws Exception {
        try {
            String userEmail = this.getUserEmail(this.getUsername(request));
            return this.getTaskClient(storeId).restoreSnapshot(snapshotId, userEmail).serialize();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/spaces/restores/request"}, method={RequestMethod.POST})
    @ResponseBody
    public String requestRestore(HttpServletRequest request, @RequestParam String storeId, @RequestParam String snapshotId) throws Exception {
        try {
            String userEmail = this.getUserEmail(this.getUsername(request));
            return this.getTaskClient(storeId).requestRestoreSnapshot(snapshotId, userEmail).serialize();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isSnapshotInProgress(ContentStore store, String spaceId) {
        try {
            return store.getSpaceProperties(spaceId).containsKey("snapshot-id");
        }
        catch (ContentStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ContentStore getContentStore(String storeId) throws ContentStoreException {
        return this.contentStoreManager.getContentStore(storeId);
    }
}

