/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.duracloud.client.ContentStore;
import org.duracloud.common.util.TagUtil;
import org.duracloud.duradmin.util.NameValuePair;
import org.duracloud.error.ContentStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PropertiesUtils {
    private static Logger log = LoggerFactory.getLogger(PropertiesUtils.class);

    public static void setProperties(ContentStore contentStore, String spaceId, String contentId, Map<String, String> properties) throws ContentStoreException {
        if (StringUtils.hasText((String)contentId)) {
            log.info("on contentStore[" + contentStore.getStoreId() + "]: " + "setting content properties: spaceId=" + spaceId + ", " + "contentId=" + contentId + ", properties=" + properties);
            contentStore.setContentProperties(spaceId, contentId, properties);
        }
    }

    public static Map<String, String> getProperties(ContentStore contentStore, String spaceId, String contentId) throws ContentStoreException {
        if (StringUtils.hasText((String)contentId)) {
            Map properties = contentStore.getContentProperties(spaceId, contentId);
            log.info("from contentStore[" + contentStore.getStoreId() + "]: " + "getting content properties: spaceId=" + spaceId + ", " + "contentId=" + contentId + ", properties=" + properties);
            return properties;
        }
        Map properties = contentStore.getSpaceProperties(spaceId);
        log.info("from contentStore[" + contentStore.getStoreId() + "]: " + "getting space properties: spaceId=" + spaceId + ", " + "contentId=" + contentId + ", properties=" + properties);
        return properties;
    }

    public static List<NameValuePair> convertExtendedProperties(Map<String, String> properties) {
        LinkedList<NameValuePair> extendedProperties = new LinkedList<NameValuePair>();
        if (extendedProperties != null) {
            for (String name : properties.keySet()) {
                extendedProperties.add(new NameValuePair(name, (Object)properties.get(name)));
            }
        }
        return extendedProperties;
    }

    public static Object remove(String name, Map<String, String> properties) {
        return properties.remove(name);
    }

    public static Object add(String name, String value, Map<String, String> properties) {
        return properties.put(name, value);
    }

    public static Object getValue(String key, Map<String, String> properties) {
        return properties.get(key);
    }

    public static void handle(String method, String context, Map<String, String> properties, HttpServletRequest request) {
        if (method.equals("addRemove")) {
            String[] names = PropertiesUtils.extractList((String)"properties-name-remove", (HttpServletRequest)request);
            String[] values = PropertiesUtils.extractList((String)"properties-value-remove", (HttpServletRequest)request);
            PropertiesUtils.remove((String[])names, (String[])values, properties);
            names = PropertiesUtils.extractList((String)"properties-name-add", (HttpServletRequest)request);
            values = PropertiesUtils.extractList((String)"properties-value-add", (HttpServletRequest)request);
            PropertiesUtils.add((String[])names, (String[])values, properties);
            String[] tags = PropertiesUtils.extractList((String)"tag-remove", (HttpServletRequest)request);
            TagUtil.remove((String[])tags, properties);
            tags = PropertiesUtils.extractList((String)"tag-add", (HttpServletRequest)request);
            TagUtil.add((String[])tags, properties);
        } else {
            String tag = request.getParameter("tag");
            String name = request.getParameter("properties-name");
            String value = request.getParameter("properties-value");
            if (method.equals("addTag")) {
                TagUtil.addTag((String)tag, properties);
                log.info("added tag [{}] to [{}]", (Object)tag, (Object)context);
            } else if (method.equals("removeTag")) {
                TagUtil.removeTag((String)tag, properties);
                log.info("removed tag [{}] from [{}]", (Object)tag, (Object)context);
            } else if (method.equals("addProperties")) {
                PropertiesUtils.add((String)name, (String)value, properties);
                log.info("added properties [{}] to  [{}]", (Object)(name + ":" + value), (Object)context);
            } else if (method.equals("removeProperties")) {
                PropertiesUtils.remove((String)name, properties);
                log.info("removed properties [{}] from  [{}]", (Object)(name + ":" + value), (Object)context);
            } else {
                log.warn("unexpected method parameter: " + method);
            }
        }
    }

    private static String[] extractList(String prefix, HttpServletRequest request) {
        String value;
        LinkedList<String> values = new LinkedList<String>();
        int count = 0;
        while ((value = request.getParameter(prefix + "-" + count)) != null) {
            values.add(value);
            ++count;
        }
        return values.toArray(new String[0]);
    }

    private static void add(String[] names, String[] values, Map<String, String> properties) {
        for (int i = 0; i < names.length; ++i) {
            PropertiesUtils.add((String)names[i], (String)values[i], properties);
        }
    }

    private static void remove(String[] names, String[] values, Map<String, String> properties) {
        for (int i = 0; i < names.length; ++i) {
            PropertiesUtils.remove((String)names[i], properties);
        }
    }
}

