/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.security;

import java.util.Arrays;
import java.util.Collection;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.model.Credential;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;

public class ContentStoreAuthenticationProvider
implements AuthenticationProvider {
    private ContentStoreManager contentStoreManager;
    private static Collection<GrantedAuthority> USER_AUTHORITY = Arrays.asList(new GrantedAuthorityImpl("ROLE_USER"));

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), USER_AUTHORITY);
        try {
            this.contentStoreManager.login(new Credential(username, password));
        }
        catch (Exception ex) {
            auth.setAuthenticated(false);
        }
        return auth;
    }

    public boolean supports(Class authentication) {
        return true;
    }

    public ContentStoreManager getContentStoreManager() {
        return this.contentStoreManager;
    }

    public void setContentStoreManager(ContentStoreManager contentStoreManager) {
        this.contentStoreManager = contentStoreManager;
    }
}

