/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.config;

import java.util.Properties;
import org.duracloud.common.util.ApplicationConfig;
import org.duracloud.duradmin.domain.AdminInit;

public class DuradminConfig
extends ApplicationConfig {
    private static AdminInit config = null;
    private static String DURADMIN_PROPERTIES_NAME = "duradmin.properties";
    private static String configFileName;
    private static String hostKey;
    private static String portKey;
    private static String durastoreContextKey;
    private static String duraserviceContextKey;
    private static String durabossContextKey;
    private static String millDbEnabledKey;
    private static boolean initialized;

    private static Properties getProps() {
        return ApplicationConfig.getPropsFromResource((String)DuradminConfig.getConfigFileName());
    }

    public static String getPropsHost() {
        return DuradminConfig.getProps().getProperty(hostKey);
    }

    public static String getPropsPort() {
        return DuradminConfig.getProps().getProperty(portKey);
    }

    public static String getPropsDuraStoreContext() {
        return DuradminConfig.getProps().getProperty(durastoreContextKey);
    }

    public static String getPropsDuraServiceContext() {
        return DuradminConfig.getProps().getProperty(duraserviceContextKey);
    }

    public static Boolean isPropsMillDbEnabled() {
        return Boolean.valueOf(DuradminConfig.getProps().getProperty(millDbEnabledKey));
    }

    public static void setConfigFileName(String name) {
        configFileName = name;
    }

    public static String getConfigFileName() {
        if (configFileName == null) {
            configFileName = DURADMIN_PROPERTIES_NAME;
        }
        return configFileName;
    }

    public static void setConfig(AdminInit init) {
        config = init;
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getDuraStoreHost() {
        DuradminConfig.checkInitialized();
        return config.getDuraStoreHost();
    }

    public static String getDuraStorePort() {
        DuradminConfig.checkInitialized();
        return config.getDuraStorePort();
    }

    public static String getDuraStoreContext() {
        DuradminConfig.checkInitialized();
        return config.getDuraStoreContext();
    }

    public static boolean isMillDbEnabled() {
        DuradminConfig.checkInitialized();
        return config.isMillDbEnabled();
    }

    public String getAmaUrl() {
        DuradminConfig.checkInitialized();
        return config.getAmaUrl();
    }

    private static void checkInitialized() {
        if (config == null) {
            DuradminConfig.initFromProperties();
        }
    }

    private static void initFromProperties() {
        config = new AdminInit();
        config.setDuraStoreHost(DuradminConfig.getPropsHost());
        config.setDuraStorePort(DuradminConfig.getPropsPort());
        config.setDuraStoreContext(DuradminConfig.getPropsDuraStoreContext());
        config.setDuraBossContext(DuradminConfig.getPropsDuraBossContext());
        config.setAmaUrl(null);
        config.setMillDbEnabled(DuradminConfig.isPropsMillDbEnabled());
    }

    private static String getPropsDuraBossContext() {
        return DuradminConfig.getProps().getProperty(durabossContextKey, "duraboss");
    }

    public static String getDuraBossHost() {
        return DuradminConfig.getPropsHost();
    }

    public static String getDuraBossPort() {
        return DuradminConfig.getPropsPort();
    }

    public static String getDuraBossContext() {
        return DuradminConfig.getPropsDuraBossContext();
    }

    static {
        hostKey = "host";
        portKey = "port";
        durastoreContextKey = "durastoreContext";
        duraserviceContextKey = "duraserviceContext";
        durabossContextKey = "durabossContext";
        millDbEnabledKey = "millDbEnabled";
        initialized = false;
    }
}

