/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.control;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.duracloud.appconfig.domain.Application;
import org.duracloud.duradmin.config.DuradminConfig;
import org.duracloud.duradmin.domain.SecurityUserCommand;
import org.duracloud.security.DuracloudUserDetailsService;
import org.duracloud.security.domain.SecurityUserBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Deprecated
@Controller
public class ManageSecurityUsersController {
    private final Logger log = LoggerFactory.getLogger(ManageSecurityUsersController.class);
    private DuracloudUserDetailsService userDetailsService;
    private PasswordEncoder passwordEncoder;

    @Autowired
    public ManageSecurityUsersController(DuracloudUserDetailsService userDetailsService, PasswordEncoder passwordEncoder) {
        this.userDetailsService = userDetailsService;
        this.passwordEncoder = passwordEncoder;
    }

    @RequestMapping(value={"/admin"})
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, SecurityUserCommand cmd, BindingResult result) throws Exception {
        cmd.setUsers(this.userDetailsService.getUsers());
        String verb = cmd.getVerb();
        String username = cmd.getUsername();
        String password = this.passwordEncoder.encodePassword(cmd.getPassword(), null);
        if (verb.equalsIgnoreCase("add")) {
            ArrayList<String> grants = new ArrayList<String>();
            grants.add("ROLE_USER");
            SecurityUserBean user = new SecurityUserBean(username, password, grants);
            cmd.addUser(user);
            this.log.info("added user {}", (Object)user.getUsername());
            return this.saveAndReturnModel(cmd, user);
        }
        if (verb.equalsIgnoreCase("remove")) {
            SecurityUserBean user = this.getUser(cmd);
            cmd.removeUser(user.getUsername());
            this.log.info("removed user {}", (Object)username);
            return this.saveAndReturnModel(cmd, user);
        }
        if (verb.equalsIgnoreCase("modify")) {
            SecurityUserBean user = this.getUser(cmd);
            user.setPassword(password);
            this.log.info("updated password for user {}", (Object)username);
            return this.saveAndReturnModel(cmd, user);
        }
        return new ModelAndView("admin-manager", "users", (Object)cmd.getUsers());
    }

    private SecurityUserBean getUser(SecurityUserCommand cmd) {
        for (SecurityUserBean user : cmd.getUsers()) {
            if (!user.getUsername().equals(cmd.getUsername())) continue;
            return user;
        }
        return null;
    }

    private ModelAndView saveAndReturnModel(SecurityUserCommand cmd, SecurityUserBean user) throws Exception {
        this.pushUpdates(cmd.getUsers());
        user.setPassword("*********");
        return new ModelAndView("jsonView", "user", (Object)user);
    }

    private void pushUpdates(List<SecurityUserBean> users) throws Exception {
        this.userDetailsService.setUsers(users);
        this.log.debug("pushed updates to user details service");
        Application durastore = this.getDuraStoreApp();
        durastore.setSecurityUsers(users);
        this.log.debug("pushed updates to durastore");
    }

    private Application getDuraStoreApp() {
        String host = DuradminConfig.getDuraStoreHost();
        String port = DuradminConfig.getDuraStorePort();
        String ctxt = DuradminConfig.getDuraStoreContext();
        return new Application(host, port, ctxt);
    }

    public DuracloudUserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(DuracloudUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }
}

