/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.control;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.duracloud.client.ContentStore;
import org.duracloud.duradmin.control.ControllerSupport;
import org.duracloud.duradmin.util.SpaceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ContentItemDownloadController {
    private ControllerSupport controllerSupport;

    @Autowired
    public ContentItemDownloadController(ControllerSupport controllerSupport) {
        this.controllerSupport = controllerSupport;
    }

    @RequestMapping(value={"/download/contentItem"}, method={RequestMethod.GET})
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String storeId = request.getParameter("storeID");
        if (storeId == null) {
            storeId = request.getParameter("storeId");
        }
        if (storeId == null) {
            storeId = this.controllerSupport.getContentStoreManager().getPrimaryContentStore().getStoreId();
        }
        String spaceId = request.getParameter("spaceId");
        String contentId = request.getParameter("contentId");
        String attachment = request.getParameter("attachment");
        if (Boolean.valueOf(attachment).booleanValue()) {
            StringBuffer contentDisposition = new StringBuffer();
            contentDisposition.append("attachment;");
            contentDisposition.append("filename=\"");
            contentDisposition.append(contentId);
            contentDisposition.append("\"");
            response.setHeader("Content-Disposition", contentDisposition.toString());
        }
        ContentStore store = this.controllerSupport.getContentStoreManager().getContentStore(storeId);
        SpaceUtil.streamContent(store, response, spaceId, contentId);
        return null;
    }
}

