/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.duckdb.DuckDBAppender;
import org.duckdb.DuckDBDatabaseMetaData;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBPreparedStatement;
import org.duckdb.JdbcUtils;
import org.duckdb.user.DuckDBMap;
import org.duckdb.user.DuckDBUserArray;
import org.duckdb.user.DuckDBUserStruct;

public final class DuckDBConnection
implements Connection {
    public static final String DEFAULT_SCHEMA = "main";
    ByteBuffer conn_ref;
    boolean autoCommit = true;
    boolean transactionRunning;
    final String url;
    private final boolean readOnly;

    public static DuckDBConnection newConnection(String url, boolean readOnly, Properties properties) throws SQLException {
        if (!url.startsWith("jdbc:duckdb:")) {
            throw new SQLException("DuckDB JDBC URL needs to start with 'jdbc:duckdb:'");
        }
        String db_dir = url.substring("jdbc:duckdb:".length()).trim();
        if (db_dir.length() == 0) {
            db_dir = ":memory:";
        }
        ByteBuffer nativeReference = DuckDBNative.duckdb_jdbc_startup(db_dir.getBytes(StandardCharsets.UTF_8), readOnly, properties);
        return new DuckDBConnection(nativeReference, url, readOnly);
    }

    private DuckDBConnection(ByteBuffer connectionReference, String url, boolean readOnly) throws SQLException {
        this.conn_ref = connectionReference;
        this.url = url;
        this.readOnly = readOnly;
        DuckDBNative.duckdb_jdbc_set_auto_commit(connectionReference, true);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        if (resultSetConcurrency == 1007 && resultSetType == 1003) {
            return new DuckDBPreparedStatement(this);
        }
        throw new SQLFeatureNotSupportedException("createStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        if (resultSetConcurrency == 1007 && resultSetType == 1003) {
            return new DuckDBPreparedStatement(this, sql);
        }
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public Connection duplicate() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        return new DuckDBConnection(DuckDBNative.duckdb_jdbc_connect(this.conn_ref), this.url, this.readOnly);
    }

    @Override
    public void commit() throws SQLException {
        try (Statement s = this.createStatement();){
            s.execute("COMMIT");
            this.transactionRunning = false;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try (Statement s = this.createStatement();){
            s.execute("ROLLBACK");
            this.transactionRunning = false;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.conn_ref != null) {
            DuckDBNative.duckdb_jdbc_disconnect(this.conn_ref);
            this.conn_ref = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn_ref == null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level > 4) {
            throw new SQLFeatureNotSupportedException("setTransactionIsolation");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 4;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly != this.readOnly) {
            throw new SQLFeatureNotSupportedException("Can't change read-only status on connection level.");
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        if (this.autoCommit != autoCommit) {
            this.autoCommit = autoCommit;
            if (this.transactionRunning && autoCommit) {
                this.commit();
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        return this.autoCommit;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 0);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new DuckDBDatabaseMetaData(this);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        DuckDBNative.duckdb_jdbc_set_catalog(this.conn_ref, catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return DuckDBNative.duckdb_jdbc_get_catalog(this.conn_ref);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        DuckDBNative.duckdb_jdbc_set_schema(this.conn_ref, schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return DuckDBNative.duckdb_jdbc_get_schema(this.conn_ref);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return JdbcUtils.unwrap(this, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("abort");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createBlob");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("nativeSQL");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 0);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 0);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        if (map != null && map instanceof HashMap && map.isEmpty()) {
            return;
        }
        throw new SQLFeatureNotSupportedException("setTypeMap");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("setHoldability");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("getHoldability");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("rollback");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("releaseSavepoint");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("createSQLXML");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClientInfo");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException("getClientInfo");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return new DuckDBUserArray(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return new DuckDBUserStruct(typeName, attributes);
    }

    public <K, V> Map<K, V> createMap(String typeName, Map<K, V> map) {
        return new DuckDBMap<K, V>(typeName, map);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNetworkTimeout");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("getNetworkTimeout");
    }

    public DuckDBAppender createAppender(String schemaName, String tableName) throws SQLException {
        return new DuckDBAppender(this, schemaName, tableName);
    }

    private static long getArrowStreamAddress(Object arrow_array_stream) {
        try {
            Class<?> arrow_array_stream_class = Class.forName("org.apache.arrow.c.ArrowArrayStream");
            if (!arrow_array_stream_class.isInstance(arrow_array_stream)) {
                throw new RuntimeException("Need to pass an ArrowArrayStream");
            }
            return (Long)arrow_array_stream_class.getMethod("memoryAddress", new Class[0]).invoke(arrow_array_stream, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerArrowStream(String name, Object arrow_array_stream) {
        long array_stream_address = DuckDBConnection.getArrowStreamAddress(arrow_array_stream);
        DuckDBNative.duckdb_jdbc_arrow_register(this.conn_ref, array_stream_address, name.getBytes(StandardCharsets.UTF_8));
    }
}

