/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import org.duckdb.DuckDBColumnType;
import org.duckdb.DuckDBColumnTypeMetaData;
import org.duckdb.DuckDBResultSet;

public class DuckDBResultSetMetaData
implements ResultSetMetaData {
    protected int param_count;
    protected int column_count;
    protected String[] column_names;
    protected String[] column_types_string;
    protected String[] column_types_details;
    protected DuckDBColumnType[] column_types;
    protected DuckDBColumnTypeMetaData[] column_types_meta;

    public DuckDBResultSetMetaData(int n, int n2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.param_count = n;
        this.column_count = n2;
        this.column_names = stringArray;
        this.column_types_string = stringArray2;
        this.column_types_details = stringArray3;
        ArrayList<DuckDBColumnType> arrayList = new ArrayList<DuckDBColumnType>(n2);
        ArrayList<DuckDBColumnTypeMetaData> arrayList2 = new ArrayList<DuckDBColumnTypeMetaData>(n2);
        for (String string : this.column_types_string) {
            arrayList.add(DuckDBResultSetMetaData.TypeNameToType(string));
        }
        this.column_types = new DuckDBColumnType[n2];
        this.column_types = arrayList.toArray(this.column_types);
        for (String string : this.column_types_details) {
            if (!string.equals("")) {
                String[] stringArray4 = string.split(";");
                arrayList2.add(new DuckDBColumnTypeMetaData(Short.parseShort(stringArray4[0].replace("DECIMAL", "")), Short.parseShort(stringArray4[1]), Short.parseShort(stringArray4[2])));
                continue;
            }
            arrayList2.add(null);
        }
        this.column_types_meta = arrayList2.toArray(new DuckDBColumnTypeMetaData[n2]);
    }

    public static DuckDBColumnType TypeNameToType(String string) {
        if (string.startsWith("DECIMAL")) {
            return DuckDBColumnType.DECIMAL;
        }
        if (string.equals("TIMESTAMP WITH TIME ZONE")) {
            return DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE;
        }
        return DuckDBColumnType.valueOf(string);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.column_count;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_names[n - 1];
    }

    public static int type_to_int(DuckDBColumnType duckDBColumnType) throws SQLException {
        switch (duckDBColumnType) {
            case BOOLEAN: {
                return 16;
            }
            case TINYINT: {
                return -6;
            }
            case SMALLINT: {
                return 5;
            }
            case INTEGER: {
                return 4;
            }
            case BIGINT: {
                return -5;
            }
            case HUGEINT: {
                return 2000;
            }
            case UTINYINT: {
                return 2000;
            }
            case USMALLINT: {
                return 2000;
            }
            case UINTEGER: {
                return 2000;
            }
            case UBIGINT: {
                return 2000;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 3;
            }
            case VARCHAR: {
                return 12;
            }
            case TIME: {
                return 92;
            }
            case DATE: {
                return 91;
            }
            case TIMESTAMP: {
                return 93;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return 2013;
            }
            case INTERVAL: {
                return 2000;
            }
            case BLOB: {
                return 2004;
            }
        }
        throw new SQLException("Unsupported type " + duckDBColumnType.toString());
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return DuckDBResultSetMetaData.type_to_int(this.column_types[n - 1]);
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case 16: {
                return Boolean.class.toString();
            }
            case -6: {
                return Byte.class.toString();
            }
            case 5: {
                return Short.class.toString();
            }
            case 4: {
                return Integer.class.toString();
            }
            case -5: {
                return Long.class.toString();
            }
            case 6: {
                return Float.class.toString();
            }
            case 8: {
                return Double.class.toString();
            }
            case 12: {
                return String.class.toString();
            }
            case 92: {
                return Time.class.toString();
            }
            case 91: {
                return Date.class.toString();
            }
            case 93: {
                return Timestamp.class.toString();
            }
            case 2013: {
                return OffsetDateTime.class.toString();
            }
            case 2004: {
                return DuckDBResultSet.DuckDBBlobResult.class.toString();
            }
            case 3: {
                return BigDecimal.class.toString();
            }
        }
        throw new SQLException("Unknown type " + this.getColumnTypeName(n));
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_types_string[n - 1];
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        return true;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return 1;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        DuckDBColumnTypeMetaData duckDBColumnTypeMetaData = this.typeMetadataForColumn(n);
        if (duckDBColumnTypeMetaData == null) {
            return 0;
        }
        return duckDBColumnTypeMetaData.width;
    }

    @Override
    public int getScale(int n) throws SQLException {
        DuckDBColumnTypeMetaData duckDBColumnTypeMetaData = this.typeMetadataForColumn(n);
        if (duckDBColumnTypeMetaData == null) {
            return 0;
        }
        return duckDBColumnTypeMetaData.scale;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private DuckDBColumnTypeMetaData typeMetadataForColumn(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_types_meta[n - 1];
    }
}

