/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class DuckDBTimestamp {
    static final LocalDateTime RefLocalDateTime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
    protected long timeMicros;

    public DuckDBTimestamp(long l) {
        this.timeMicros = l;
    }

    public DuckDBTimestamp(Timestamp timestamp) {
        this.timeMicros = RefLocalDateTime.until(timestamp.toLocalDateTime(), ChronoUnit.MICROS);
    }

    public static Timestamp toSqlTimestamp(long l) {
        return Timestamp.valueOf(LocalDateTime.ofEpochSecond(DuckDBTimestamp.micros2seconds(l), DuckDBTimestamp.nanosPartMicros(l), ZoneOffset.UTC));
    }

    public static LocalDateTime toLocalDateTime(long l) {
        return LocalDateTime.ofEpochSecond(DuckDBTimestamp.micros2seconds(l), DuckDBTimestamp.nanosPartMicros(l), ZoneOffset.UTC);
    }

    public Timestamp toSqlTimestamp() {
        return Timestamp.valueOf(this.toLocalDateTime());
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.ofEpochSecond(DuckDBTimestamp.micros2seconds(this.timeMicros), DuckDBTimestamp.nanosPartMicros(this.timeMicros), ZoneOffset.UTC);
    }

    public static long getMicroseconds(Timestamp timestamp) {
        return RefLocalDateTime.until(timestamp.toLocalDateTime(), ChronoUnit.MICROS);
    }

    public long getMicrosEpoch() {
        return this.timeMicros;
    }

    public String toString() {
        return this.toLocalDateTime().toString();
    }

    private static long micros2seconds(long l) {
        return l / 1000000L;
    }

    private static int nanosPartMicros(long l) {
        return (int)(l % 1000000L * 1000L);
    }
}

