/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBParameterMetaData;
import org.duckdb.DuckDBResultSet;
import org.duckdb.DuckDBResultSetMetaData;

public class DuckDBPreparedStatement
implements PreparedStatement {
    private DuckDBConnection conn;
    private ByteBuffer stmt_ref = null;
    private DuckDBResultSet select_result = null;
    private int update_result = 0;
    private boolean is_update = false;
    private Object[] params = new Object[0];
    private DuckDBResultSetMetaData meta = null;

    public DuckDBPreparedStatement(DuckDBConnection duckDBConnection) throws SQLException {
        if (duckDBConnection == null) {
            throw new SQLException("connection parameter cannot be null");
        }
        this.conn = duckDBConnection;
    }

    public DuckDBPreparedStatement(DuckDBConnection duckDBConnection, String string) throws SQLException {
        if (duckDBConnection == null) {
            throw new SQLException("connection parameter cannot be null");
        }
        if (string == null) {
            throw new SQLException("sql query parameter cannot be null");
        }
        this.conn = duckDBConnection;
        this.prepare(string);
    }

    private void prepare(String string) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (string == null) {
            throw new SQLException("sql query parameter cannot be null");
        }
        this.stmt_ref = null;
        this.meta = null;
        this.params = null;
        this.select_result = null;
        this.update_result = 0;
        this.stmt_ref = DuckDBNative.duckdb_jdbc_prepare(this.conn.conn_ref, string.getBytes(StandardCharsets.UTF_8));
        this.meta = DuckDBNative.duckdb_jdbc_meta(this.stmt_ref);
        this.params = new Object[0];
        String string2 = DuckDBNative.duckdb_jdbc_prepare_type(this.stmt_ref);
        this.is_update = !string2.equals("SELECT") && !string2.equals("PRAGMA") && !string2.equals("EXPLAIN");
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmt_ref == null) {
            throw new SQLException("Prepare something first");
        }
        ByteBuffer byteBuffer = DuckDBNative.duckdb_jdbc_execute(this.stmt_ref, this.params);
        this.select_result = new DuckDBResultSet(this, this.meta, byteBuffer);
        return !this.is_update;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.is_update) {
            throw new SQLException("executeQuery() can only be used with SELECT queries");
        }
        this.execute();
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (!this.is_update) {
            throw new SQLException("executeUpdate() cannot be used with SELECT queries");
        }
        this.execute();
        this.update_result = 0;
        if (this.select_result.next()) {
            this.update_result = this.select_result.getInt(1);
        }
        this.select_result.close();
        return this.update_result;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.prepare(string);
        return this.execute();
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.prepare(string);
        return this.executeQuery();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.prepare(string);
        return this.executeUpdate();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmt_ref == null || this.select_result == null) {
            throw new SQLException("Prepare and execute something first");
        }
        return this.select_result.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmt_ref == null) {
            throw new SQLException("Prepare something first");
        }
        return new DuckDBParameterMetaData(this.meta);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (n < 1 || n > this.getParameterMetaData().getParameterCount()) {
            throw new SQLException("Parameter index out of bounds");
        }
        if (this.params.length == 0) {
            this.params = new Object[this.getParameterMetaData().getParameterCount()];
        }
        this.params[n - 1] = object;
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.setObject(n, null);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setObject(n, bl);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.setObject(n, by);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.setObject(n, s);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.setObject(n, n2);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.setObject(n, l);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.setObject(n, Float.valueOf(f));
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.setObject(n, d);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.setObject(n, string);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.params = new Object[0];
    }

    @Override
    public void close() throws SQLException {
        if (this.stmt_ref != null) {
            DuckDBNative.duckdb_jdbc_release(this.stmt_ref);
            this.stmt_ref = null;
        }
        this.conn = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmt_ref == null) {
            throw new SQLException("Prepare something first");
        }
        if (this.is_update) {
            return null;
        }
        return this.select_result;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        if (this.stmt_ref == null) {
            throw new SQLException("Prepare something first");
        }
        if (!this.is_update) {
            return -1;
        }
        return this.update_result;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return DuckDBNative.duckdb_jdbc_fetch_size();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement was closed");
        }
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn == null;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -7: 
            case 16: {
                if (object instanceof Boolean) {
                    this.setObject(n, object);
                    break;
                }
                if (object instanceof Number) {
                    this.setObject(n, ((Number)object).byteValue() == 1);
                    break;
                }
                if (object instanceof String) {
                    this.setObject(n, Boolean.parseBoolean((String)object));
                    break;
                }
                throw new SQLException("Can't convert value to boolean " + object.getClass().toString());
            }
            case -6: {
                if (object instanceof Byte) {
                    this.setObject(n, object);
                    break;
                }
                if (object instanceof Number) {
                    this.setObject(n, ((Number)object).byteValue());
                    break;
                }
                if (object instanceof String) {
                    this.setObject(n, Byte.parseByte((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setObject(n, (byte)((Boolean)object != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Can't convert value to byte " + object.getClass().toString());
            }
            case 5: {
                if (object instanceof Short) {
                    this.setObject(n, object);
                    break;
                }
                if (object instanceof Number) {
                    this.setObject(n, ((Number)object).shortValue());
                    break;
                }
                if (object instanceof String) {
                    this.setObject(n, Short.parseShort((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setObject(n, (short)((Boolean)object != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Can't convert value to short " + object.getClass().toString());
            }
            case 4: {
                if (object instanceof Integer) {
                    this.setObject(n, object);
                    break;
                }
                if (object instanceof Number) {
                    this.setObject(n, ((Number)object).intValue());
                    break;
                }
                if (object instanceof String) {
                    this.setObject(n, Integer.parseInt((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setObject(n, (Boolean)object != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Can't convert value to int " + object.getClass().toString());
            }
            case -5: {
                if (object instanceof Long) {
                    this.setObject(n, object);
                    break;
                }
                if (object instanceof Number) {
                    this.setObject(n, ((Number)object).longValue());
                    break;
                }
                if (object instanceof String) {
                    this.setObject(n, Long.parseLong((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setObject(n, (Boolean)object != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Can't convert value to long " + object.getClass().toString());
            }
            case 6: 
            case 7: {
                if (object instanceof Float) {
                    this.setObject(n, object);
                    break;
                }
                if (object instanceof Number) {
                    this.setObject(n, Float.valueOf(((Number)object).floatValue()));
                    break;
                }
                if (object instanceof String) {
                    this.setObject(n, Float.valueOf(Float.parseFloat((String)object)));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setObject(n, Float.valueOf((Boolean)object != false ? 1 : 0));
                    break;
                }
                throw new SQLException("Can't convert value to float " + object.getClass().toString());
            }
            case 2: 
            case 3: 
            case 8: {
                if (object instanceof Double) {
                    this.setObject(n, object);
                    break;
                }
                if (object instanceof Number) {
                    this.setObject(n, ((Number)object).doubleValue());
                    break;
                }
                if (object instanceof String) {
                    this.setObject(n, Double.parseDouble((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setObject(n, (Boolean)object != false ? 1 : 0);
                    break;
                }
                throw new SQLException("Can't convert value to double " + object.getClass().toString());
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof String) {
                    this.setObject(n, (String)object);
                    break;
                }
                this.setObject(n, object.toString());
                break;
            }
            default: {
                throw new SQLException("Unknown target type " + n2);
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

