/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;

public class DuckDBResultSetMetaData
implements ResultSetMetaData {
    protected int param_count;
    protected int column_count;
    protected String[] column_names;
    protected String[] column_types;

    public DuckDBResultSetMetaData(int n, int n2, String[] stringArray, String[] stringArray2) {
        this.param_count = n;
        this.column_count = n2;
        this.column_names = stringArray;
        this.column_types = stringArray2;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.column_count;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_names[n - 1];
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        String string = this.getColumnTypeName(n);
        if (string.equals("BOOLEAN")) {
            return 16;
        }
        if (string.equals("TINYINT")) {
            return -6;
        }
        if (string.equals("SMALLINT")) {
            return 5;
        }
        if (string.equals("INTEGER")) {
            return 4;
        }
        if (string.equals("BIGINT")) {
            return -5;
        }
        if (string.equals("FLOAT")) {
            return 6;
        }
        if (string.equals("DOUBLE") || string.startsWith("DECIMAL")) {
            return 8;
        }
        if (string.equals("VARCHAR")) {
            return 12;
        }
        if (string.equals("TIME")) {
            return 92;
        }
        if (string.equals("DATE")) {
            return 91;
        }
        if (string.equals("TIMESTAMP")) {
            return 93;
        }
        if (string.equals("INTERVAL")) {
            return 12;
        }
        throw new SQLException("Unknown type " + string);
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case 16: {
                return Boolean.class.toString();
            }
            case -6: {
                return Byte.class.toString();
            }
            case 5: {
                return Short.class.toString();
            }
            case 4: {
                return Integer.class.toString();
            }
            case -5: {
                return Long.class.toString();
            }
            case 6: {
                return Float.class.toString();
            }
            case 8: {
                return Double.class.toString();
            }
            case 12: {
                return String.class.toString();
            }
            case 92: {
                return Time.class.toString();
            }
            case 91: {
                return Date.class.toString();
            }
            case 93: {
                return Timestamp.class.toString();
            }
        }
        throw new SQLException("Unknown type " + this.getColumnTypeName(n));
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        if (n > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_types[n - 1];
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        return true;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return 1;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int n) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

