/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.CollectionCollectionGenerator;
import org.dspace.sword2.CommunityCollectionGenerator;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordAuthenticator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.SwordUrlManager;
import org.dspace.sword2.WorkflowManagerFactory;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.ServiceDocument;
import org.swordapp.server.ServiceDocumentManager;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordCollection;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;
import org.swordapp.server.SwordWorkspace;

public class ServiceDocumentManagerDSpace
implements ServiceDocumentManager {
    private static Logger log = LogManager.getLogger(ServiceDocumentManagerDSpace.class);
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();

    public ServiceDocument getServiceDocument(String sdUri, AuthCredentials authCredentials, SwordConfiguration config) throws SwordError, SwordServerException, SwordAuthException {
        SwordContext sc = null;
        try {
            SwordAuthenticator auth = new SwordAuthenticator();
            sc = auth.authenticate(authCredentials);
            Context context = sc.getContext();
            WorkflowManagerFactory.getInstance().retrieveServiceDoc(context);
            if (log.isDebugEnabled()) {
                log.debug(org.dspace.core.LogManager.getHeader((Context)context, (String)"sword_do_service_document", (String)""));
            }
            String un = authCredentials.getUsername() != null ? authCredentials.getUsername() : "NONE";
            String obo = authCredentials.getOnBehalfOf() != null ? authCredentials.getOnBehalfOf() : "NONE";
            log.info(org.dspace.core.LogManager.getHeader((Context)context, (String)"sword_service_document_request", (String)("username=" + un + ",on_behalf_of=" + obo)));
            ServiceDocument serviceDocument = this.getServiceDocument(sc, sdUri, (SwordConfigurationDSpace)config);
            return serviceDocument;
        }
        catch (DSpaceSwordException e) {
            log.error("caught exception: ", (Throwable)e);
            throw new SwordServerException("The DSpace SWORD interface experienced an error", (Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public ServiceDocument getServiceDocument(SwordContext context, String url, SwordConfigurationDSpace swordConfig) throws SwordError, SwordServerException, DSpaceSwordException {
        if (context == null) {
            throw new DSpaceSwordException("The Sword Context is null; please set it before calling getServiceDocument");
        }
        WorkflowManagerFactory.getInstance().retrieveServiceDoc(context.getContext());
        SwordUrlManager urlManager = swordConfig.getUrlManager(context.getContext(), swordConfig);
        SwordAuthenticator swordAuth = new SwordAuthenticator();
        CommunityCollectionGenerator comGen = new CommunityCollectionGenerator();
        CollectionCollectionGenerator colGen = new CollectionCollectionGenerator();
        ServiceDocument service = new ServiceDocument();
        service.setMaxUploadSize(swordConfig.getMaxUploadSize());
        if (url == null || urlManager.isBaseServiceDocumentUrl(url)) {
            String ws = ConfigurationManager.getProperty((String)"dspace.name");
            SwordWorkspace workspace = new SwordWorkspace();
            workspace.setTitle(ws);
            boolean swordCommunities = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"expose-communities");
            if (swordCommunities) {
                List comms = swordAuth.getAllowedCommunities(context);
                for (Community comm : comms) {
                    SwordCollection scol = comGen.buildCollection(context.getContext(), (DSpaceObject)comm, swordConfig);
                    workspace.addCollection(scol);
                }
            } else {
                List cols = swordAuth.getAllowedCollections(context);
                for (Collection col : cols) {
                    SwordCollection scol = colGen.buildCollection(context.getContext(), (DSpaceObject)col, swordConfig);
                    workspace.addCollection(scol);
                }
            }
            service.addWorkspace(workspace);
        } else {
            DSpaceObject dso = urlManager.extractDSpaceObject(url);
            if (dso == null) {
                throw new SwordError(404);
            }
            if (dso instanceof Community) {
                Community community = (Community)dso;
                SwordWorkspace workspace = new SwordWorkspace();
                workspace.setTitle(this.communityService.getName((DSpaceObject)community));
                List collections = swordAuth.getAllowedCollections(context, community);
                for (Collection collection : collections) {
                    SwordCollection scol = colGen.buildCollection(context.getContext(), (DSpaceObject)collection, swordConfig);
                    workspace.addCollection(scol);
                }
                List communities = swordAuth.getCommunities(context, community);
                for (Community comm : communities) {
                    SwordCollection scol = comGen.buildCollection(context.getContext(), (DSpaceObject)comm, swordConfig);
                    workspace.addCollection(scol);
                }
                service.addWorkspace(workspace);
            }
        }
        return service;
    }
}

