/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.sword2.AtomCollectionGenerator;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.SwordCollection;

public class CommunityCollectionGenerator
implements AtomCollectionGenerator {
    private static Logger log = LogManager.getLogger(CommunityCollectionGenerator.class);
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();

    public SwordCollection buildCollection(Context context, DSpaceObject dso, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException {
        String firstValue;
        List abstracts;
        if (!(dso instanceof Community)) {
            log.error("buildCollection passed something other than a Community object");
            throw new DSpaceSwordException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SwordUrlManager urlManager = swordConfig.getUrlManager(context, swordConfig);
        Community com = (Community)dso;
        SwordCollection scol = new SwordCollection();
        String location = urlManager.getDepositLocation(com);
        if (location == null) {
            location = this.handleService.getCanonicalForm(com.getHandle());
        }
        scol.setLocation(location);
        String title = this.communityService.getName((DSpaceObject)com);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            scol.setTitle(title);
        }
        if ((abstracts = this.communityService.getMetadataByMetadataString((DSpaceObject)com, "short_description")) != null && !abstracts.isEmpty() && StringUtils.isNotBlank((CharSequence)(firstValue = ((MetadataValue)abstracts.get(0)).getValue()))) {
            scol.setAbstract(firstValue);
        }
        scol.setMediation(swordConfig.isMediated());
        String subService = urlManager.constructSubServiceUrl(com);
        scol.addSubService(new IRI(subService));
        log.debug("Created ATOM Collection for DSpace Community");
        return scol;
    }
}

