/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.AbstractSwordContentIngester;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.SwordContentIngester;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractSwordContentIngester
implements SwordContentIngester {
    public static final Logger log = LogManager.getLogger(AbstractSwordContentIngester.class);
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public DepositResult ingest(Context context, Deposit deposit, DSpaceObject dso, VerboseDescription verboseDescription) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        return this.ingest(context, deposit, dso, verboseDescription, null);
    }

    public DepositResult ingest(Context context, Deposit deposit, DSpaceObject dso, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        if (dso instanceof Collection) {
            return this.ingestToCollection(context, deposit, (Collection)dso, verboseDescription, result);
        }
        if (dso instanceof Item) {
            return this.ingestToItem(context, deposit, (Item)dso, verboseDescription, result);
        }
        return null;
    }

    public abstract DepositResult ingestToCollection(Context var1, Deposit var2, Collection var3, VerboseDescription var4, DepositResult var5) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException;

    public abstract DepositResult ingestToItem(Context var1, Deposit var2, Item var3, VerboseDescription var4, DepositResult var5) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException;

    protected BitstreamFormat getFormat(Context context, String fileName) throws SQLException {
        String fext = null;
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot > -1) {
            fext = fileName.substring(lastDot + 1);
        }
        if (fext == null) {
            return null;
        }
        List formats = this.bitstreamFormatService.findAll(context);
        for (BitstreamFormat format : formats) {
            List extensions = format.getExtensions();
            for (String ext : extensions) {
                if (!ext.equals(fext)) continue;
                return format;
            }
        }
        return null;
    }

    protected void setUpdatedDate(Context context, Item item, VerboseDescription verboseDescription) throws DSpaceSwordException {
        String field = ConfigurationManager.getProperty((String)"swordv2-server", (String)"updated.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSwordException("No configuration, or configuration is invalid for: sword.updated.field");
        }
        MetadataFieldInfo info = this.configToDC(field, null);
        try {
            this.itemService.clearMetadata(context, (DSpaceObject)item, MetadataFieldInfo.access$000((MetadataFieldInfo)info), MetadataFieldInfo.access$100((MetadataFieldInfo)info), MetadataFieldInfo.access$200((MetadataFieldInfo)info), "*");
            DCDate date = new DCDate(new Date());
            this.itemService.addMetadata(context, (DSpaceObject)item, MetadataFieldInfo.access$000((MetadataFieldInfo)info), MetadataFieldInfo.access$100((MetadataFieldInfo)info), MetadataFieldInfo.access$200((MetadataFieldInfo)info), null, date.toString());
        }
        catch (SQLException e) {
            log.error("Caught exception trying to set update date", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
        verboseDescription.append("Updated date added to response from item metadata where available");
    }

    protected void setSlug(Context context, Item item, String slugVal, VerboseDescription verboseDescription) throws DSpaceSwordException {
        if (slugVal == null) {
            return;
        }
        String field = ConfigurationManager.getProperty((String)"swordv2-server", (String)"slug.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSwordException("No configuration, or configuration is invalid for: sword.slug.field");
        }
        MetadataFieldInfo info = this.configToDC(field, null);
        try {
            this.itemService.clearMetadata(context, (DSpaceObject)item, MetadataFieldInfo.access$000((MetadataFieldInfo)info), MetadataFieldInfo.access$100((MetadataFieldInfo)info), MetadataFieldInfo.access$200((MetadataFieldInfo)info), "*");
            this.itemService.addMetadata(context, (DSpaceObject)item, MetadataFieldInfo.access$000((MetadataFieldInfo)info), MetadataFieldInfo.access$100((MetadataFieldInfo)info), MetadataFieldInfo.access$200((MetadataFieldInfo)info), null, slugVal);
        }
        catch (SQLException e) {
            log.error("Caught exception trying to set slug", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
        verboseDescription.append("Slug value set in response where available");
    }

    private MetadataFieldInfo configToDC(String config, String def) {
        MetadataFieldInfo mfi = new MetadataFieldInfo(this, null);
        MetadataFieldInfo.access$002((MetadataFieldInfo)mfi, (String)def);
        MetadataFieldInfo.access$102((MetadataFieldInfo)mfi, (String)def);
        MetadataFieldInfo.access$202((MetadataFieldInfo)mfi, (String)def);
        StringTokenizer stz = new StringTokenizer(config, ".");
        MetadataFieldInfo.access$002((MetadataFieldInfo)mfi, (String)stz.nextToken());
        MetadataFieldInfo.access$102((MetadataFieldInfo)mfi, (String)stz.nextToken());
        if (stz.hasMoreTokens()) {
            MetadataFieldInfo.access$202((MetadataFieldInfo)mfi, (String)stz.nextToken());
        }
        return mfi;
    }
}

