/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.sword2.SimpleDCMetadata;

public class AbstractSimpleDC {
    protected HashMap<String, String> dcMap = null;
    protected HashMap<String, String> atomMap = null;
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    protected void loadMetadataMaps() {
        String v;
        String k;
        String keyString;
        Properties props;
        if (this.dcMap == null) {
            this.dcMap = new HashMap();
            props = ConfigurationManager.getProperties((String)"swordv2-server");
            for (Object key : props.keySet()) {
                keyString = (String)key;
                if (!keyString.startsWith("simpledc.")) continue;
                k = keyString.substring("simpledc.".length());
                v = (String)props.get(key);
                this.dcMap.put(k, v);
            }
        }
        if (this.atomMap == null) {
            this.atomMap = new HashMap();
            props = ConfigurationManager.getProperties((String)"swordv2-server");
            for (Object key : props.keySet()) {
                keyString = (String)key;
                if (!keyString.startsWith("atom.")) continue;
                k = keyString.substring("atom.".length());
                v = (String)props.get(key);
                this.atomMap.put(k, v);
            }
        }
    }

    protected SimpleDCMetadata getMetadata(Item item) {
        this.loadMetadataMaps();
        SimpleDCMetadata md = new SimpleDCMetadata();
        List all = this.itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*");
        for (MetadataValue dcv : all) {
            String value;
            MetadataField field = dcv.getMetadataField();
            String valueMatch = field.getMetadataSchema().getName() + "." + field.getElement();
            if (field.getQualifier() != null) {
                valueMatch = valueMatch + "." + field.getQualifier();
            }
            for (String key : this.dcMap.keySet()) {
                value = (String)this.dcMap.get(key);
                if (!valueMatch.equals(value)) continue;
                md.addDublinCore(key, dcv.getValue());
            }
            for (String key : this.atomMap.keySet()) {
                value = (String)this.atomMap.get(key);
                if (!valueMatch.equals(value)) continue;
                md.addAtom(key, dcv.getValue());
            }
        }
        return md;
    }
}

