/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.sword2.AbstractSwordContentIngester;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.UriRegistry;

public class SimpleZipContentIngester
extends AbstractSwordContentIngester {
    public DepositResult ingestToCollection(Context context, Deposit deposit, Collection collection, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException {
        try {
            File depositFile = deposit.getFile();
            Item item = null;
            WorkspaceItem wsi = null;
            if (result != null) {
                item = result.getItem();
            } else {
                result = new DepositResult();
            }
            if (item == null) {
                wsi = WorkspaceItem.create((Context)context, (Collection)collection, (boolean)true);
                item = wsi.getItem();
            }
            Bundle[] originals = item.getBundles("ORIGINAL");
            Bundle bundle = null;
            bundle = originals.length > 0 ? originals[0] : item.createBundle("ORIGINAL");
            List derivedResources = this.unzipToBundle(context, depositFile, bundle);
            item.addMetadata("dc", "title", null, null, "Untitled: " + deposit.getFilename());
            item.addMetadata("dc", "description", null, null, "Zip file deposted by SWORD without accompanying metadata");
            this.setUpdatedDate(item, verboseDescription);
            this.setSlug(item, deposit.getSlug(), verboseDescription);
            context.turnOffAuthorisationSystem();
            item.update();
            context.restoreAuthSystemState();
            verboseDescription.append("Ingest successful");
            verboseDescription.append("Item created with internal identifier: " + item.getID());
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            result.setDerivedResources(derivedResources);
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    private List<Bitstream> unzipToBundle(Context context, File depositFile, Bundle target) throws DSpaceSwordException, SwordError, SwordAuthException {
        try {
            ZipFile zip = new ZipFile(depositFile);
            ArrayList<Bitstream> derivedResources = new ArrayList<Bitstream>();
            Enumeration<? extends ZipEntry> zenum = zip.entries();
            while (zenum.hasMoreElements()) {
                ZipEntry entry = zenum.nextElement();
                InputStream stream = zip.getInputStream(entry);
                Bitstream bs = target.createBitstream(stream);
                BitstreamFormat format = this.getFormat(context, entry.getName());
                bs.setFormat(format);
                bs.setName(entry.getName());
                bs.update();
                derivedResources.add(bs);
            }
            return derivedResources;
        }
        catch (ZipException e) {
            throw new SwordError(UriRegistry.ERROR_BAD_REQUEST, "unable to unzip provided package", (Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
    }

    public DepositResult ingestToItem(Context context, Deposit deposit, Item item, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException {
        try {
            if (result == null) {
                result = new DepositResult();
            }
            result.setItem(item);
            File depositFile = deposit.getFile();
            Bundle[] originals = item.getBundles("ORIGINAL");
            Bundle original = null;
            original = originals.length > 0 ? originals[0] : item.createBundle("ORIGINAL");
            List derivedResources = this.unzipToBundle(context, depositFile, original);
            this.setUpdatedDate(item, verboseDescription);
            context.turnOffAuthorisationSystem();
            item.update();
            context.restoreAuthSystemState();
            verboseDescription.append("Replace successful");
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            result.setDerivedResources(derivedResources);
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    private String getTreatment() throws DSpaceSwordException {
        return "The package has been ingested and unpacked into the item.  Template metadata for the collection has been used, and a default title with the name of the file has been set";
    }
}

