/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.HashMap;
import java.util.Properties;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;
import org.dspace.sword2.SimpleDCMetadata;

public class AbstractSimpleDC {
    protected HashMap<String, String> dcMap = null;
    protected HashMap<String, String> atomMap = null;

    protected void loadMetadataMaps() {
        String v;
        String k;
        String keyString;
        Properties props;
        if (this.dcMap == null) {
            this.dcMap = new HashMap();
            props = ConfigurationManager.getProperties((String)"swordv2-server");
            for (Object key : props.keySet()) {
                keyString = (String)key;
                if (!keyString.startsWith("simpledc.")) continue;
                k = keyString.substring("simpledc.".length());
                v = (String)props.get(key);
                this.dcMap.put(k, v);
            }
        }
        if (this.atomMap == null) {
            this.atomMap = new HashMap();
            props = ConfigurationManager.getProperties((String)"swordv2-server");
            for (Object key : props.keySet()) {
                keyString = (String)key;
                if (!keyString.startsWith("atom.")) continue;
                k = keyString.substring("atom.".length());
                v = (String)props.get(key);
                this.atomMap.put(k, v);
            }
        }
    }

    protected SimpleDCMetadata getMetadata(Item item) {
        Metadatum[] all;
        this.loadMetadataMaps();
        SimpleDCMetadata md = new SimpleDCMetadata();
        for (Metadatum dcv : all = item.getMetadata("*", "*", "*", "*")) {
            String value;
            String valueMatch = dcv.schema + "." + dcv.element;
            if (dcv.qualifier != null) {
                valueMatch = valueMatch + "." + dcv.qualifier;
            }
            for (String key : this.dcMap.keySet()) {
                value = (String)this.dcMap.get(key);
                if (!valueMatch.equals(value)) continue;
                md.addDublinCore(key, dcv.value);
            }
            for (String key : this.atomMap.keySet()) {
                value = (String)this.atomMap.get(key);
                if (!valueMatch.equals(value)) continue;
                md.addAtom(key, dcv.value);
            }
        }
        return md;
    }
}

