/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.Metadatum;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.sword2.DSpaceSwordAPI;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.SwordUrlManager;
import org.dspace.workflow.WorkflowItem;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.CollectionListManager;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class CollectionListManagerDSpace
extends DSpaceSwordAPI
implements CollectionListManager {
    public Feed listCollectionContents(IRI colIRI, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordServerException, SwordError, SwordAuthException {
        SwordContext sc = null;
        try {
            Feed feed;
            SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            SwordUrlManager urlManager = config.getUrlManager(context, config);
            Collection collection = urlManager.getCollection(context, colIRI.toString());
            if (collection == null) {
                throw new SwordError(404);
            }
            List items = this.listItems(sc, collection, swordConfig);
            Feed feed2 = feed = this.itemListToFeed(sc, items, swordConfig);
            return feed2;
        }
        catch (DSpaceSwordException e) {
            throw new SwordServerException((Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    private Feed itemListToFeed(SwordContext sc, List<Item> items, SwordConfiguration swordConfig) throws DSpaceSwordException {
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        SwordUrlManager urlManager = config.getUrlManager(sc.getContext(), config);
        Abdera abdera = new Abdera();
        Feed feed = abdera.newFeed();
        for (Item item : items) {
            Entry entry = feed.addEntry();
            entry.setId(urlManager.getEditIRI(item).toString());
            String title = this.stringMetadata(item, ConfigurationManager.getProperty((String)"swordv2-server", (String)"title.field"));
            title = title == null ? "Untitled" : title;
            entry.setTitle(title);
            entry.addLink(urlManager.getContentUrl(item).toString(), "edit-media");
        }
        return feed;
    }

    /*
     * WARNING - void declaration
     */
    private List<Item> listItems(SwordContext sc, Collection collection, SwordConfiguration swordConfig) throws DSpaceSwordException {
        try {
            void var11_18;
            WorkflowItem[] wfis;
            int n;
            EPerson person = sc.getOnBehalfOf() != null ? sc.getOnBehalfOf() : sc.getAuthenticated();
            ArrayList<Item> collectionItems = new ArrayList<Item>();
            ItemIterator items = Item.findBySubmitter((Context)sc.getContext(), (EPerson)person);
            block2: while (items.hasNext()) {
                Collection[] cols;
                Item item = items.next();
                Collection[] collectionArray = cols = item.getCollections();
                n = collectionArray.length;
                for (int i = 0; i < n; ++i) {
                    Collection col = collectionArray[i];
                    if (col.getID() != collection.getID()) continue;
                    collectionItems.add(item);
                    continue block2;
                }
            }
            WorkspaceItem[] wsis = WorkspaceItem.findByEPerson((Context)sc.getContext(), (EPerson)person);
            block4: for (Collection collection2 : wsis) {
                Collection[] cols;
                Item item = collection2.getItem();
                Collection wsCol = collection2.getCollection();
                if (wsCol.getID() == collection.getID()) {
                    collectionItems.add(item);
                }
                for (Collection col : cols = item.getCollections()) {
                    if (col.getID() != collection.getID()) continue;
                    collectionItems.add(item);
                    continue block4;
                }
            }
            WorkflowItem[] workflowItemArray = wfis = WorkflowItem.findByEPerson((Context)sc.getContext(), (EPerson)person);
            n = workflowItemArray.length;
            boolean bl = false;
            while (var11_18 < n) {
                Collection[] cols;
                WorkflowItem wfi = workflowItemArray[var11_18];
                Item item = wfi.getItem();
                Collection wfCol = wfi.getCollection();
                if (wfCol.getID() == collection.getID()) {
                    collectionItems.add(item);
                }
                for (Collection col : cols = item.getCollections()) {
                    if (col.getID() != collection.getID()) continue;
                    collectionItems.add(item);
                    break;
                }
                ++var11_18;
            }
            return collectionItems;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    private String stringMetadata(Item item, String field) {
        if (field == null) {
            return null;
        }
        Metadatum[] dcvs = item.getMetadataByMetadataString(field);
        if (dcvs == null) {
            return null;
        }
        StringBuilder md = new StringBuilder();
        for (Metadatum dcv : dcvs) {
            if (md.length() > 0) {
                md.append(", ");
            }
            md.append(dcv.value);
        }
        return md.toString();
    }
}

