/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.WingMergeableElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Body
extends AbstractWingElement
implements WingMergeableElement {
    public static final String E_BODY = "body";
    private boolean merged = false;
    private final List<Division> divisions = new ArrayList();

    protected Body(WingContext context) throws WingException {
        super(context);
    }

    public Division addDivision(String name, String rend) throws WingException {
        Division div = new Division(this.context, name, rend);
        this.divisions.add(div);
        return div;
    }

    public Division addDivision(String name) throws WingException {
        return this.addDivision(name, null);
    }

    public Division addInteractiveDivision(String name, String action, String method, String rend) throws WingException {
        Division div = new Division(this.context, name, action, method, rend);
        this.divisions.add(div);
        return div;
    }

    public boolean mergeEqual(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (!WingConstants.DRI.URI.equals(namespace)) {
            return false;
        }
        return E_BODY.equals(localName);
    }

    public WingMergeableElement mergeChild(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        Division found = null;
        for (Division candidate : this.divisions) {
            if (!candidate.mergeEqual(namespace, localName, qName, attributes)) continue;
            found = candidate;
        }
        this.divisions.remove(found);
        return found;
    }

    public Attributes merge(Attributes attributes) throws SAXException, WingException {
        this.merged = true;
        return attributes;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        if (!this.merged) {
            this.startElement(contentHandler, namespaces, E_BODY, null);
        }
        for (Division division : this.divisions) {
            division.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (!this.merged) {
            this.endElement(contentHandler, namespaces, E_BODY);
        }
    }

    public void dispose() {
        for (Division division : this.divisions) {
            division.dispose();
        }
        super.dispose();
    }
}

