/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.cocoon.SafeResourceReader;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class ThemeResourceReader
extends SafeResourceReader
implements CacheableProcessingComponent,
Configurable {
    protected String[] DEFAULT_WHITELIST = new String[]{"css", "js", "json", "gif", "jpg", "jpeg", "png", "ico", "bmp", "htm", "html", "svg", "ttf", "woff", "hbs"};
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String[] whitelist;
        if (par.getParameterAsBoolean("bypass-whitelist", false)) {
            super.setup(resolver, objectModel, src, par);
            return;
        }
        for (String suffix : whitelist = this.configurationService.getArrayProperty("xmlui.theme.whitelist", this.DEFAULT_WHITELIST)) {
            if (src == null || !src.toLowerCase().endsWith("." + suffix)) continue;
            super.setup(resolver, objectModel, src, par);
            return;
        }
        throw new ResourceNotFoundException("Resource not found (" + src + ")");
    }
}

