/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExport;
import org.dspace.app.xmlui.aspect.discovery.SimpleSearch;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchMetadataExportReader
extends AbstractReader
implements Recyclable {
    private static final String AUTH_REQUIRED_HEADER = "xmlui.ItemExportDownloadReader.auth_header";
    private static final String AUTH_REQUIRED_MESSAGE = "xmlui.ItemExportDownloadReader.auth_message";
    protected static final int BUFFER_SIZE = 8192;
    protected static final int expires = 216000000;
    protected Response response;
    protected Request request;
    private static Logger log = Logger.getLogger(SearchMetadataExportReader.class);
    private AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private DSpaceCSV csv = null;
    private String filename = null;
    private SimpleSearch simpleSearch = null;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.request = ObjectModelHelper.getRequest((Map)objectModel);
            this.response = ObjectModelHelper.getResponse((Map)objectModel);
            String query = this.request.getParameter("query");
            String scope = this.request.getParameter("scope");
            String filters = this.request.getParameter("filters");
            Context context = ContextUtil.obtainContext((Map)objectModel);
            String search_export_config = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("xmlui.search.metadata_export");
            if (search_export_config.equals("admin")) {
                if (!this.authorizeService.isAdmin(context)) {
                    if (AuthenticationUtil.isLoggedIn((HttpServletRequest)this.request)) {
                        String redictURL = this.request.getContextPath() + "/restricted-resource";
                        HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                        httpResponse.sendRedirect(redictURL);
                        return;
                    }
                    String redictURL = this.request.getContextPath() + "/login";
                    AuthenticationUtil.interruptRequest((Map)objectModel, (String)"xmlui.ItemExportDownloadReader.auth_header", (String)"xmlui.ItemExportDownloadReader.auth_message", null);
                    HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                    httpResponse.sendRedirect(redictURL);
                    return;
                }
            } else if (search_export_config.equals("user") && !AuthenticationUtil.isLoggedIn((HttpServletRequest)this.request)) {
                String redictURL = this.request.getContextPath() + "/login";
                AuthenticationUtil.interruptRequest((Map)objectModel, (String)"xmlui.ItemExportDownloadReader.auth_header", (String)"xmlui.ItemExportDownloadReader.auth_message", null);
                HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                httpResponse.sendRedirect(redictURL);
                return;
            }
            this.simpleSearch = new SimpleSearch();
            this.csv = this.exportMetadata(context, objectModel, query, scope, filters);
            this.filename = "search-results.csv";
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to export metadata.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to read bitstream.", (Throwable)e);
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.response.setContentType("text/csv; charset=UTF-8");
        this.response.setHeader("Content-Disposition", "attachment; filename=" + this.filename);
        this.out.write(this.csv.toString().getBytes("UTF-8"));
        this.out.flush();
        this.out.close();
    }

    public void recycle() {
        this.response = null;
        this.request = null;
    }

    public DSpaceCSV exportMetadata(Context context, Map objectModel, String query, String scopeString, String filters) throws IOException, UIException, SearchServiceException, SQLException {
        DSpaceObject scope;
        DiscoverResult qResults = new DiscoverResult();
        DiscoverQuery qArgs = new DiscoverQuery();
        if (scopeString != null && scopeString.length() > 0) {
            scopeString = scopeString.replace("~", "/");
            scope = this.handleService.resolveToObject(context, scopeString);
        } else {
            scope = HandleUtil.obtainHandle((Map)objectModel);
        }
        this.simpleSearch.objectModel = objectModel;
        String[] fqs = filters != null ? filters.split(",") : new String[]{};
        qArgs = this.simpleSearch.prepareQuery(scope, query, fqs);
        qArgs.setStart(0);
        qArgs.setMaxResults(10);
        qResults = SearchUtils.getSearchService().search(context, scope, qArgs);
        qArgs.setMaxResults(SearchMetadataExportReader.safeLongToInt((long)qResults.getTotalSearchResults()));
        qResults = SearchUtils.getSearchService().search(context, scope, qArgs);
        ArrayList<Item> items = new ArrayList<Item>();
        for (DSpaceObject resultDSO : qResults.getDspaceObjects()) {
            if (!(resultDSO instanceof Item)) continue;
            items.add((Item)resultDSO);
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exporting_search"));
        MetadataExport exporter = new MetadataExport(context, items.iterator(), false);
        DSpaceCSV csv = exporter.export();
        log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exported_file:search-results.csv"));
        return csv;
    }

    public static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int.");
        }
        return (int)l;
    }
}

