/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.statistics;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_statistics_head = Navigation.message((String)"xmlui.statistics.Navigation.title");
    private static final Message T_statistics_usage_view = Navigation.message((String)"xmlui.statistics.Navigation.usage.view");
    private static final Message T_statistics_search_view = Navigation.message((String)"xmlui.statistics.Navigation.search.view");
    private static final Message T_statistics_workflow_view = Navigation.message((String)"xmlui.statistics.Navigation.workflow.view");
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    public Serializable getKey() {
        return null;
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        options.addList("browse");
        options.addList("account");
        options.addList("context");
        options.addList("administrative");
        List statistics = options.addList("statistics");
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        boolean displayUsageStats = this.displayStatsType(this.context, "usage", dso);
        boolean displaySearchStats = this.displayStatsType(this.context, "search", dso);
        boolean displayWorkflowStats = this.displayStatsType(this.context, "workflow", dso);
        if (dso != null && dso.getHandle() != null) {
            statistics.setHead(T_statistics_head);
            if (displayUsageStats) {
                statistics.addItemXref(this.contextPath + "/handle/" + dso.getHandle() + "/statistics", T_statistics_usage_view);
            }
            if (displaySearchStats && dso.getType() != 2) {
                statistics.addItemXref(this.contextPath + "/handle/" + dso.getHandle() + "/search-statistics", T_statistics_search_view);
            }
            if (displayWorkflowStats && dso.getType() != 2) {
                statistics.addItemXref(this.contextPath + "/handle/" + dso.getHandle() + "/workflow-statistics", T_statistics_workflow_view);
            }
        } else {
            statistics.setHead(T_statistics_head);
            if (displayUsageStats) {
                statistics.addItemXref(this.contextPath + "/statistics-home", T_statistics_usage_view.parameterize(new Object[0]));
            }
            if (displaySearchStats) {
                statistics.addItemXref(this.contextPath + "/search-statistics", T_statistics_search_view);
            }
            if (displayWorkflowStats) {
                statistics.addItemXref(this.contextPath + "/workflow-statistics", T_statistics_workflow_view);
            }
        }
    }

    protected boolean displayStatsType(Context context, String type, DSpaceObject dso) throws SQLException {
        ConfigurationService cs = DSpaceServicesFactory.getInstance().getConfigurationService();
        return (Boolean)cs.getPropertyAsType("usage-statistics.authorization.admin." + type, (Object)Boolean.TRUE) == false || this.authorizeService.isAdmin(context, dso);
    }
}

