/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Reference;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.ItemCountException;
import org.dspace.browse.ItemCounter;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class CommunityViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(CommunityViewer.class);
    private static final Message T_dspace_home = CommunityViewer.message((String)"xmlui.general.dspace_home");
    public static final Message T_untitled = CommunityViewer.message((String)"xmlui.general.untitled");
    private static final Message T_head_sub_communities = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.head_sub_communities");
    private static final Message T_head_sub_collections = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.head_sub_collections");
    private SourceValidity validity;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private ItemCounter itemCounter = null;
    private boolean showCount = this.configurationService.getBooleanProperty("webui.strengths.show");

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        if (this.showCount) {
            try {
                this.itemCounter = new ItemCounter(this.context);
            }
            catch (ItemCountException e) {
                log.error((Object)e);
            }
        }
    }

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            Community community = null;
            try {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso == null) {
                    return null;
                }
                if (!(dso instanceof Community)) {
                    return null;
                }
                community = (Community)dso;
                DSpaceValidity validity = new DSpaceValidity();
                validity.add(this.context, (DSpaceObject)community);
                List subCommunities = community.getSubcommunities();
                List collections = community.getCollections();
                for (Community subCommunity : subCommunities) {
                    validity.add(this.context, (DSpaceObject)subCommunity);
                    if (!this.showCount) continue;
                    try {
                        int size = this.itemCounter.getCount((DSpaceObject)subCommunity);
                        validity.add("size:" + size);
                    }
                    catch (ItemCountException size) {}
                }
                for (Collection collection : collections) {
                    validity.add(this.context, (DSpaceObject)collection);
                    boolean showCount = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("webui.strengths.show");
                    if (!showCount) continue;
                    try {
                        int size = this.itemCounter.getCount((DSpaceObject)collection);
                        validity.add("size:" + size);
                    }
                    catch (ItemCountException itemCountException) {}
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Community)) {
            return;
        }
        Community community = (Community)dso;
        String name = community.getName();
        if (name == null || name.length() == 0) {
            pageMeta.addMetadata("title").addContent(T_untitled);
        } else {
            pageMeta.addMetadata("title").addContent(name);
        }
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((Context)this.context, (DSpaceObject)community, (PageMeta)pageMeta, (String)this.contextPath);
        String[] formats = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("webui.feed.formats");
        if (formats != null) {
            for (String format : formats) {
                String[] parts = format.split("_");
                if (parts.length < 1) continue;
                String feedFormat = parts[0].trim() + "+xml";
                String feedURL = this.contextPath + "/feed/" + format.trim() + "/" + community.getHandle();
                pageMeta.addMetadata("feed", feedFormat).addContent(feedURL);
            }
        }
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        ReferenceSet communityReferenceSet;
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Community)) {
            return;
        }
        Community community = (Community)dso;
        List subCommunities = community.getSubcommunities();
        List collections = community.getCollections();
        Division home = body.addDivision("community-home", "primary repository community");
        String name = community.getName();
        if (name == null || name.length() == 0) {
            home.setHead(T_untitled);
        } else {
            home.setHead(name);
        }
        home.addDivision("community-search-browse", "secondary search-browse");
        Division viewer = home.addDivision("community-view", "secondary");
        ReferenceSet referenceSet = viewer.addReferenceSet("community-view", "detailView");
        Reference communityInclude = referenceSet.addReference((Object)community);
        if (subCommunities != null && subCommunities.size() > 0) {
            communityReferenceSet = communityInclude.addReferenceSet("summaryList", null, "hierarchy");
            communityReferenceSet.setHead(T_head_sub_communities);
            for (Community subCommunity : subCommunities) {
                communityReferenceSet.addReference((Object)subCommunity);
            }
        }
        if (collections != null && collections.size() > 0) {
            communityReferenceSet = communityInclude.addReferenceSet("summaryList", null, "hierarchy");
            communityReferenceSet.setHead(T_head_sub_collections);
            for (Collection collection : collections) {
                communityReferenceSet.addReference((Object)collection);
            }
        }
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

