/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.RichTextContainer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Value
extends RichTextContainer {
    public static final String E_VALUE = "value";
    public static final String A_TYPE = "type";
    public static final String A_OPTION = "option";
    public static final String A_CHECKED = "checked";
    public static final String A_CONFIDENCE = "confidence";
    public static final String TYPE_RAW = "raw";
    public static final String TYPE_INTERPRETED = "interpreted";
    public static final String TYPE_OPTION = "option";
    public static final String TYPE_AUTHORITY = "authority";
    public static final String[] TYPES = new String[]{"raw", "interpreted", "option", "authority"};
    private String type;
    private String option;
    private boolean checked;
    private String confidence = null;

    protected Value(WingContext context, String type) throws WingException {
        super(context);
        if (type == null) {
            type = TYPE_RAW;
        }
        this.restrict(type, TYPES, "The 'type' parameter must be one of these values: 'raw', 'interpreted', or 'option'");
        this.type = type;
    }

    protected Value(WingContext context, String type, String optionOrConfidence) throws WingException {
        super(context);
        if (type == null) {
            type = TYPE_RAW;
        }
        this.restrict(type, TYPES, "The 'type' parameter must be one of these values: 'raw', 'interpreted', or 'option'.");
        this.type = type;
        if (type.equals(TYPE_AUTHORITY)) {
            this.confidence = optionOrConfidence;
        } else {
            this.option = optionOrConfidence;
        }
    }

    protected Value(WingContext context, String type, boolean checked) throws WingException {
        super(context);
        if (type == null) {
            type = TYPE_RAW;
        }
        this.restrict(type, TYPES, "The 'type' parameter must be one of these values: 'raw', 'interpreted', or 'option'.");
        this.type = type;
        this.checked = checked;
    }

    protected String getType() {
        return this.type;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)A_TYPE, (Object)this.type);
        if (this.option != null) {
            attributes.put((Object)"option", (Object)this.option);
        }
        if (this.checked) {
            attributes.put(A_CHECKED, this.checked);
        }
        if (this.type.equals(TYPE_AUTHORITY)) {
            attributes.put((Object)A_CONFIDENCE, (Object)this.confidence);
        }
        this.startElement(contentHandler, namespaces, E_VALUE, attributes);
        super.toSAX(contentHandler, lexicalHandler, namespaces);
        this.endElement(contentHandler, namespaces, E_VALUE);
    }
}

