/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.xmlui.utils.RequestInfo;

public class RequestInfo {
    private final String authType;
    private final String contextPath;
    private final String method;
    private final String pathInfo;
    private final String pathTranslated;
    private final String queryString;
    private final String requestURI;
    private final StringBuffer requestURL;
    private final String servletPath;
    private final String scheme;
    private final boolean secure;
    private final Map<String, String[]> parameters;

    public RequestInfo(HttpServletRequest request) {
        this.authType = request.getAuthType();
        this.contextPath = request.getContextPath();
        this.method = request.getMethod();
        this.pathInfo = request.getPathInfo();
        this.pathTranslated = request.getPathTranslated();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.requestURL = request.getRequestURL();
        this.servletPath = request.getServletPath();
        this.scheme = request.getScheme();
        this.secure = request.isSecure();
        this.parameters = new HashMap();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String[] values = request.getParameterValues(key);
            this.parameters.put(key, values);
        }
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getActualPath() {
        return this.pathInfo + (this.queryString == null || this.queryString.length() == 0 ? "" : "?" + this.queryString);
    }

    public HttpServletRequest wrapRequest(HttpServletRequest request) {
        return new RequestWrapper(this, request);
    }

    static /* synthetic */ String access$000(RequestInfo x0) {
        return x0.authType;
    }

    static /* synthetic */ String access$100(RequestInfo x0) {
        return x0.contextPath;
    }

    static /* synthetic */ String access$200(RequestInfo x0) {
        return x0.method;
    }

    static /* synthetic */ String access$300(RequestInfo x0) {
        return x0.pathInfo;
    }

    static /* synthetic */ String access$400(RequestInfo x0) {
        return x0.pathTranslated;
    }

    static /* synthetic */ String access$500(RequestInfo x0) {
        return x0.queryString;
    }

    static /* synthetic */ String access$600(RequestInfo x0) {
        return x0.requestURI;
    }

    static /* synthetic */ StringBuffer access$700(RequestInfo x0) {
        return x0.requestURL;
    }

    static /* synthetic */ String access$800(RequestInfo x0) {
        return x0.servletPath;
    }

    static /* synthetic */ Map access$900(RequestInfo x0) {
        return x0.parameters;
    }

    static /* synthetic */ String access$1000(RequestInfo x0) {
        return x0.scheme;
    }

    static /* synthetic */ boolean access$1100(RequestInfo x0) {
        return x0.secure;
    }
}

