/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon.servlet.multipart;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.cocoon.servlet.multipart.Part;

public class DSpacePartOnDisk
extends Part {
    private File file = null;
    private int size;

    public DSpacePartOnDisk(Map headers, File file) {
        super(headers);
        this.file = file;
        this.file.deleteOnExit();
        this.size = file.length() > new Long(Integer.MAX_VALUE) ? Integer.MAX_VALUE : (int)file.length();
    }

    public String getFileName() {
        return this.file.getName();
    }

    public int getSize() {
        return this.size;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        throw new IllegalStateException("This part has already been disposed.");
    }

    public String toString() {
        return this.file.getPath();
    }

    public void dispose() {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

