/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.usage.UsageSearchEvent;

public abstract class SearchLoggerAction
extends AbstractAction {
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Context context = ContextUtil.obtainContext((Map)objectModel);
        DSpaceObject scope = this.getScope(context, objectModel);
        UsageSearchEvent searchEvent = new UsageSearchEvent(UsageEvent.Action.SEARCH, (HttpServletRequest)request, context, null, this.getQueries(request), scope);
        if (!StringUtils.isBlank((String)request.getParameter("rpp"))) {
            searchEvent.setRpp(Integer.parseInt(request.getParameter("rpp")));
        }
        if (!StringUtils.isBlank((String)request.getParameter("sort_by"))) {
            searchEvent.setSortBy(request.getParameter("sort_by"));
        }
        if (!StringUtils.isBlank((String)request.getParameter("order"))) {
            searchEvent.setSortOrder(request.getParameter("order"));
        }
        if (!StringUtils.isBlank((String)request.getParameter("page"))) {
            searchEvent.setPage(Integer.parseInt(request.getParameter("page")));
        }
        DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)searchEvent);
        return null;
    }

    protected abstract List<String> getQueries(Request var1) throws SQLException;

    protected DSpaceObject getScope(Context context, Map objectModel) throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle((Map)objectModel) : this.handleService.resolveToObject(context, scopeString);
        return dso;
    }
}

