/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.SAXOutputter;
import org.xml.sax.SAXException;

public class DSpaceOREGenerator
extends AbstractGenerator {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Context context = ContextUtil.obtainContext((Map)this.objectModel);
            Item item = this.getItem(context);
            if (item == null) {
                throw new ResourceNotFoundException("Unable to locate object.");
            }
            SAXOutputter out = new SAXOutputter(this.contentHandler);
            DisseminationCrosswalk xwalk = (DisseminationCrosswalk)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(DisseminationCrosswalk.class, "ore");
            Element ore = xwalk.disseminateElement(context, (DSpaceObject)item);
            out.output(ore);
        }
        catch (JDOMException je) {
            throw new ProcessingException((Exception)((Object)je));
        }
        catch (AuthorizeException ae) {
            throw new ProcessingException((Exception)((Object)ae));
        }
        catch (CrosswalkException ce) {
            throw new ProcessingException((Exception)((Object)ce));
        }
        catch (SQLException sqle) {
            throw new ProcessingException((Exception)sqle);
        }
    }

    private Item getItem(Context context) throws SQLException, CrosswalkException {
        String[] parts;
        String handle = this.parameters.getParameter("handle", null);
        String internal = this.parameters.getParameter("internal", null);
        if (handle != null) {
            DSpaceObject dso = this.handleService.resolveToObject(context, handle);
            if (dso instanceof Item) {
                return (Item)dso;
            }
            throw new CrosswalkException("ORE dissemination only available for DSpace Items.");
        }
        if (internal != null && (parts = internal.split(":")).length == 2) {
            String type = parts[0];
            UUID id = UUID.fromString(parts[1]);
            if ("item".equals(type)) {
                return (Item)this.itemService.find(context, id);
            }
            throw new CrosswalkException("ORE dissemination only available for DSpace Items.");
        }
        return null;
    }
}

