/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.xml.sax.SAXException;

public class CommunitySearch
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(CommunitySearch.class);
    private static final Message T_full_text_search = CommunitySearch.message((String)"xmlui.ArtifactBrowser.CommunityViewer.full_text_search");
    private static final Message T_go = CommunitySearch.message((String)"xmlui.general.go");
    public static final Message T_untitled = CommunitySearch.message((String)"xmlui.general.untitled");
    private static final Message T_head_sub_collections = CommunitySearch.message((String)"xmlui.ArtifactBrowser.CommunityViewer.head_sub_collections");
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            Community community = null;
            try {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso == null) {
                    return null;
                }
                if (!(dso instanceof Community)) {
                    return null;
                }
                community = (Community)dso;
                DSpaceValidity validity = new DSpaceValidity();
                validity.add(this.context, (DSpaceObject)community);
                List subCommunities = community.getSubcommunities();
                List collections = community.getCollections();
                for (Community subCommunity : subCommunities) {
                    validity.add(this.context, (DSpaceObject)subCommunity);
                }
                for (Collection collection : collections) {
                    validity.add(this.context, (DSpaceObject)collection);
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"view_community", (String)("community_id=" + (community == null ? "" : community.getID()))));
        }
        return this.validity;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Community)) {
            return;
        }
        Community community = (Community)dso;
        Division home = body.addDivision("community-home", "primary repository community");
        String name = community.getName();
        if (name == null || name.length() == 0) {
            home.setHead(T_untitled);
        } else {
            home.setHead(name);
        }
        Division search = home.addDivision("community-search-browse", "secondary search-browse");
        Division query = search.addInteractiveDivision("community-search", this.contextPath + "/handle/" + community.getHandle() + "/discover", "post", "secondary search");
        Para para = query.addPara("search-query", null);
        para.addContent(T_full_text_search);
        para.addContent(" ");
        para.addText("query");
        para.addContent(" ");
        para.addButton("submit").setValue(T_go);
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

