/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.requestitem.factory.RequestItemServiceFactory;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class ItemRequestResponseTrueForm
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_title = ItemRequestResponseTrueForm.message((String)"xmlui.ArtifactBrowser.ItemRequestResponseTrueForm.title");
    private static final Message T_dspace_home = ItemRequestResponseTrueForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = ItemRequestResponseTrueForm.message((String)"xmlui.ArtifactBrowser.ItemRequestResponseTrueForm.trail");
    private static final Message T_head = ItemRequestResponseTrueForm.message((String)"xmlui.ArtifactBrowser.ItemRequestResponseTrueForm.head");
    private static final Message T_para1 = ItemRequestResponseTrueForm.message((String)"xmlui.ArtifactBrowser.ItemRequestResponseTrueForm.para1");
    private static final Message T_mail = ItemRequestResponseTrueForm.message((String)"xmlui.ArtifactBrowser.ItemRequestResponseTrueForm.mail");
    private static final Message T_back = ItemRequestResponseTrueForm.message((String)"xmlui.ArtifactBrowser.ItemRequestResponseTrueForm.back");
    private static final Message T_message = ItemRequestResponseTrueForm.message((String)"xmlui.ArtifactBrowser.ItemRequestResponseTrueForm.message");
    private static final Message T_subject = ItemRequestResponseTrueForm.message((String)"xmlui.ArtifactBrowser.ItemRequestResponseTrueForm.subject");
    protected RequestItemService requestItemService = RequestItemServiceFactory.getInstance().getRequestItemService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public Serializable getKey() {
        String token = this.parameters.getParameter("token", "");
        String decision = this.parameters.getParameter("decision", "");
        return Long.valueOf(HashUtil.hash((String)(token + "-" + decision)));
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String token;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Context context = ContextUtil.obtainContext((Map)this.objectModel);
        RequestItem requestItem = this.requestItemService.findByToken(context, token = (String)request.getAttribute("token"));
        Item item = requestItem.getItem();
        String titleDC = item.getName();
        String title = titleDC != null && titleDC.length() > 0 ? titleDC : "untitled";
        RequestItemAuthor author = ((RequestItemAuthorExtractor)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(RequestItemAuthorExtractor.class.getName(), RequestItemAuthorExtractor.class)).getRequestItemAuthor(context, item);
        Object[] args = new String[]{requestItem.getReqName(), this.handleService.getCanonicalForm(item.getHandle()), title, author.getFullName(), author.getEmail()};
        String subject = I18nUtil.getMessage((String)"itemRequest.response.subject.approve", (Context)context);
        String messageTemplate = MessageFormat.format(I18nUtil.getMessage((String)"itemRequest.response.body.approve", (Context)context), args);
        Division itemRequest = body.addInteractiveDivision("itemRequest-form", request.getRequestURI(), "post", "primary");
        itemRequest.setHead(T_head);
        itemRequest.addPara(T_para1);
        List form = itemRequest.addList("form", "form");
        Text subj = form.addItem().addText("subject");
        subj.setLabel(T_subject);
        subj.setValue(subject);
        subj.setSize(60);
        TextArea message = form.addItem().addTextArea("message");
        message.setSize(20, 0);
        message.setLabel(T_message);
        message.setValue(this.parameters.getParameter("message", messageTemplate));
        form.addItem().addHidden("decision").setValue(this.parameters.getParameter("decision", ""));
        form.addItem().addButton("back").setValue(T_back);
        form.addItem().addButton("mail").setValue(T_mail);
    }
}

