/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.registries;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;

public class DeleteBitstreamFormatsConfirm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = DeleteBitstreamFormatsConfirm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_delete = DeleteBitstreamFormatsConfirm.message((String)"xmlui.general.delete");
    private static final Message T_submit_cancel = DeleteBitstreamFormatsConfirm.message((String)"xmlui.general.cancel");
    private static final Message T_title = DeleteBitstreamFormatsConfirm.message((String)"xmlui.administrative.registries.DeleteBitstreamFormatsConfirm.title");
    private static final Message T_format_registry_trail = DeleteBitstreamFormatsConfirm.message((String)"xmlui.administrative.registries.general.format_registry_trail");
    private static final Message T_trail = DeleteBitstreamFormatsConfirm.message((String)"xmlui.administrative.registries.DeleteBitstreamFormatsConfirm.trail");
    private static final Message T_head = DeleteBitstreamFormatsConfirm.message((String)"xmlui.administrative.registries.DeleteBitstreamFormatsConfirm.head");
    private static final Message T_para1 = DeleteBitstreamFormatsConfirm.message((String)"xmlui.administrative.registries.DeleteBitstreamFormatsConfirm.para1");
    private static final Message T_column1 = DeleteBitstreamFormatsConfirm.message((String)"xmlui.administrative.registries.DeleteBitstreamFormatsConfirm.column1");
    private static final Message T_column2 = DeleteBitstreamFormatsConfirm.message((String)"xmlui.administrative.registries.DeleteBitstreamFormatsConfirm.column2");
    private static final Message T_column3 = DeleteBitstreamFormatsConfirm.message((String)"xmlui.administrative.registries.DeleteBitstreamFormatsConfirm.column3");
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/format-registry", T_format_registry_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        String idsString = this.parameters.getParameter("formatIDs", null);
        ArrayList<BitstreamFormat> formats = new ArrayList<BitstreamFormat>();
        for (String id : idsString.split(",")) {
            BitstreamFormat format = (BitstreamFormat)this.bitstreamFormatService.find(this.context, Integer.valueOf(id).intValue());
            formats.add(format);
        }
        Division deleted = body.addInteractiveDivision("bitstream-format-confirm-delete", this.contextPath + "/admin/format-registry", "post", "primary administrative format-registry");
        deleted.setHead(T_head);
        deleted.addPara(T_para1);
        Table table = deleted.addTable("format-confirm-delete", formats.size() + 1, 3);
        Row header = table.addRow("header");
        header.addCell().addContent(T_column1);
        header.addCell().addContent(T_column2);
        header.addCell().addContent(T_column3);
        for (BitstreamFormat format : formats) {
            if (format == null) continue;
            String formatID = String.valueOf(format.getID());
            String mimetype = format.getMIMEType();
            String name = format.getShortDescription();
            Row row = table.addRow();
            row.addCell().addContent(formatID);
            row.addCell().addContent(mimetype);
            row.addCell().addContent(name);
        }
        Para buttons = deleted.addPara();
        buttons.addButton("submit_confirm").setValue(T_submit_delete);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
        deleted.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

