/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Head;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Table
extends AbstractWingElement
implements StructuralElement {
    public static final String E_TABLE = "table";
    public static final String A_ROWS = "rows";
    public static final String A_COLS = "cols";
    private String name;
    private String rend;
    private int rows;
    private int cols;
    private Head head;
    private List<AbstractWingElement> contents = new ArrayList();

    protected Table(WingContext context, String name, int rows, int cols, String rend) throws WingException {
        super(context);
        this.require(name, "The 'name' parameter is required for all tables.");
        this.greater(rows, 0, "The 'rows' parameter must be grater than zero.");
        this.greater(cols, 0, "The 'cols' parameter must be grater than zero.");
        this.name = name;
        this.rows = rows;
        this.cols = cols;
        this.rend = rend;
    }

    public Head setHead() throws WingException {
        this.head = new Head(this.context, null);
        return this.head;
    }

    public void setHead(String characters) throws WingException {
        Head head = this.setHead();
        head.addContent(characters);
    }

    public void setHead(Message message) throws WingException {
        Head head = this.setHead();
        head.addContent(message);
    }

    public Row addRow(String name, String role, String rend) throws WingException {
        Row row = new Row(this.context, name, role, rend);
        this.contents.add(row);
        return row;
    }

    public Row addRow(String role) throws WingException {
        return this.addRow(null, role, null);
    }

    public Row addRow() throws WingException {
        return this.addRow(null, null, null);
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"n", (Object)this.name);
        attributes.put((Object)"id", (Object)this.context.generateID(E_TABLE, this.name));
        attributes.put(A_ROWS, this.rows);
        attributes.put(A_COLS, this.cols);
        if (this.rend != null) {
            attributes.put((Object)"rend", (Object)this.rend);
        }
        this.startElement(contentHandler, namespaces, E_TABLE, attributes);
        if (this.head != null) {
            this.head.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        for (AbstractWingElement content : this.contents) {
            content.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        this.endElement(contentHandler, namespaces, E_TABLE);
    }

    public void dispose() {
        if (this.head != null) {
            this.head.dispose();
        }
        for (AbstractWingElement content : this.contents) {
            content.dispose();
        }
        this.head = null;
        this.contents.clear();
        this.contents = null;
        super.dispose();
    }
}

