/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkflowOverviewTransformer
extends AbstractDSpaceTransformer {
    private static final Logger log = Logger.getLogger(WorkflowOverviewTransformer.class);
    private static final int[] RESULTS_PER_PAGE_PROGRESSION = new int[]{5, 10, 20, 40, 60, 80, 100};
    private static final Message T_dspace_home = WorkflowOverviewTransformer.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.trail");
    private static final Message T_title = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.title");
    private static final Message T_go = WorkflowOverviewTransformer.message((String)"xmlui.general.go");
    private static final Message T_head = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.title");
    private static final Message T_search_column1 = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.search_column1");
    private static final Message T_search_column2 = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.search_column2");
    private static final Message T_search_column3 = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.search_column3");
    private static final Message T_search_column4 = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.search_column4");
    private static final Message T_search_column5 = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.search_column5");
    private static final Message T_button_back_to_submitter = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.button.submit_submitter");
    private static final Message T_button_delete = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.button.submit_delete");
    private static final Message T_no_results = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.WorkflowOverviewTransformer.button.no_results");

    public void addPageMeta(PageMeta pageMeta) throws WingException, SQLException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)ObjectModelHelper.getRequest((Map)this.objectModel));
        if (!AuthorizeManager.isAdmin((Context)context)) {
            throw new AuthorizeException();
        }
        Division div = body.addInteractiveDivision("xmlworkflowoverview", this.contextPath + "/admin/xmlworkflowoverview", "post", "primary");
        this.buildSearchResultsDivision(div);
    }

    protected void buildSearchResultsDivision(Division div) throws IOException, SQLException, WingException, AuthorizeException {
        int pageSize = this.getParameterRpp();
        int page = this.getParameterPage();
        try {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            int collectionIdFilter = Util.getIntParameter((HttpServletRequest)request, (String)"filter_collection");
            XmlWorkflowItem[] results = XmlWorkflowItem.findAllInCollection((Context)this.context, (int)page, (int)pageSize, (int)collectionIdFilter);
            Para para = div.addPara("result-query", "result-query");
            int hitCount = XmlWorkflowItem.countAllInCollection((Context)this.context, (int)collectionIdFilter);
            para.addContent(WorkflowOverviewTransformer.message((String)"").parameterize(new Object[]{"", hitCount}));
            div.setHead(T_head);
            this.buildSearchControls(div);
            Division resultsDiv = div.addDivision("search-results", "primary");
            if (hitCount > 0) {
                int firstItemIndex = (page - 1) * pageSize + 1;
                int lastItemIndex = (page - 1) * pageSize + results.length;
                if (hitCount < lastItemIndex) {
                    lastItemIndex = hitCount;
                }
                int pagesTotal = (hitCount - 1) / pageSize + 1;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("page", "{pageNum}");
                String pageURLMask = this.generateURL(parameters);
                resultsDiv.setMaskedPagination(hitCount, firstItemIndex, lastItemIndex, page, pagesTotal, pageURLMask);
                Table table = resultsDiv.addTable("workflow-item-overview-table", results.length + 1, 5);
                Row headerRow = table.addRow("header");
                headerRow.addCellContent(T_search_column1);
                headerRow.addCellContent(T_search_column2);
                headerRow.addCellContent(T_search_column3);
                headerRow.addCellContent(T_search_column4);
                headerRow.addCellContent(T_search_column5);
                for (XmlWorkflowItem wfi : results) {
                    Step step;
                    Workflow wf;
                    Item item = wfi.getItem();
                    Row itemRow = table.addRow();
                    List pooltasks = PoolTask.find((Context)this.context, (XmlWorkflowItem)wfi);
                    List claimedtasks = ClaimedTask.find((Context)this.context, (XmlWorkflowItem)wfi);
                    Message state = WorkflowOverviewTransformer.message((String)"xmlui.XMLWorkflow.step.unknown");
                    for (PoolTask task : pooltasks) {
                        wf = WorkflowFactory.getWorkflow((Collection)wfi.getCollection());
                        step = wf.getStep(task.getStepID());
                        state = WorkflowOverviewTransformer.message((String)("xmlui.XMLWorkflow." + wf.getID() + "." + step.getId()));
                    }
                    for (PoolTask task : claimedtasks) {
                        wf = WorkflowFactory.getWorkflow((Collection)wfi.getCollection());
                        step = wf.getStep(task.getStepID());
                        state = WorkflowOverviewTransformer.message((String)("xmlui.XMLWorkflow." + wf.getID() + "." + step.getId()));
                    }
                    itemRow.addCell().addCheckBox("workflow_id").addOption(wfi.getID());
                    itemRow.addCellContent(state);
                    itemRow.addCell().addXref(request.getContextPath() + "/admin/display-workflowItem?wfiId=" + wfi.getID(), item.getName());
                    itemRow.addCell().addXref(HandleManager.resolveToURL((Context)this.context, (String)wfi.getCollection().getHandle()), wfi.getCollection().getName());
                    itemRow.addCell().addXref("mailto:" + wfi.getSubmitter().getEmail(), wfi.getSubmitter().getFullName());
                }
                Para buttonsPara = resultsDiv.addPara();
                buttonsPara.addButton("submit_submitter").setValue(T_button_back_to_submitter);
                buttonsPara.addButton("submit_delete").setValue(T_button_delete);
            } else {
                resultsDiv.addPara(T_no_results);
            }
        }
        catch (WorkflowConfigurationException e) {
            log.error((Object)LogManager.getHeader((Context)this.context, (String)"Error while displaying the admin workflow overview page", (String)""), (Throwable)e);
        }
    }

    protected int getParameterPage() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("page"));
        }
        catch (Exception e) {
            return 1;
        }
    }

    protected int getParameterRpp() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("rpp"));
        }
        catch (Exception e) {
            return 10;
        }
    }

    protected int getParameterSortBy() {
        try {
            return Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("sort_by"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected String getParameterOrder() {
        String s = ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("order");
        return s != null ? s : "DESC";
    }

    protected String generateURL(Map<String, String> parameters) throws UIException {
        if (parameters.get("page") == null) {
            parameters.put("page", String.valueOf(this.getParameterPage()));
        }
        if (parameters.get("rpp") == null) {
            parameters.put("rpp", String.valueOf(this.getParameterRpp()));
        }
        if (parameters.get("filter_collection") == null) {
            parameters.put("filter_collection", ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("filter_collection"));
        }
        return AbstractDSpaceTransformer.generateURL((String)"xmlworkflowoverview", parameters);
    }

    protected void buildSearchControls(Division div) throws WingException, SQLException {
        Collection[] collections;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Table controlsTable = div.addTable("search-controls", 1, 3);
        Row controlsRow = controlsTable.addRow("data");
        Cell rppCell = controlsRow.addCell();
        rppCell.addContent("pagesize");
        Select rppSelect = rppCell.addSelect("rpp");
        for (int i : RESULTS_PER_PAGE_PROGRESSION) {
            rppSelect.addOption(i == this.getParameterRpp(), i, Integer.toString(i));
        }
        Cell filterCell = controlsRow.addCell();
        int selectedCollectionId = Util.getIntParameter((HttpServletRequest)request, (String)"filter_collection");
        filterCell.addContent("Collection filter:");
        Select sortSelect = filterCell.addSelect("filter_collection");
        sortSelect.addOption(-1 == selectedCollectionId, -1, "None");
        for (Collection collection : collections = Collection.findAll((Context)this.context)) {
            sortSelect.addOption(collection.getID() == selectedCollectionId, collection.getID(), collection.getName());
        }
        controlsRow.addCell().addButton("submit_search_controls").setValue(T_go);
    }
}

