/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log4j.Logger;
import org.dspace.app.util.CollectionDropDown;
import org.dspace.app.xmlui.aspect.eperson.EPersonUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Password;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.content.Collection;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.Subscribe;
import org.xml.sax.SAXException;

public class EditProfile
extends AbstractDSpaceTransformer {
    private static Logger log = Logger.getLogger(EditProfile.class);
    private static final Message T_title_create = EditProfile.message((String)"xmlui.EPerson.EditProfile.title_create");
    private static final Message T_title_update = EditProfile.message((String)"xmlui.EPerson.EditProfile.title_update");
    private static final Message T_dspace_home = EditProfile.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail_new_registration = EditProfile.message((String)"xmlui.EPerson.trail_new_registration");
    private static final Message T_trail_update = EditProfile.message((String)"xmlui.EPerson.EditProfile.trail_update");
    private static final Message T_head_create = EditProfile.message((String)"xmlui.EPerson.EditProfile.head_create");
    private static final Message T_head_update = EditProfile.message((String)"xmlui.EPerson.EditProfile.head_update");
    private static final Message T_email_address = EditProfile.message((String)"xmlui.EPerson.EditProfile.email_address");
    private static final Message T_first_name = EditProfile.message((String)"xmlui.EPerson.EditProfile.first_name");
    private static final Message T_error_required = EditProfile.message((String)"xmlui.EPerson.EditProfile.error_required");
    private static final Message T_last_name = EditProfile.message((String)"xmlui.EPerson.EditProfile.last_name");
    private static final Message T_telephone = EditProfile.message((String)"xmlui.EPerson.EditProfile.telephone");
    private static final Message T_language = EditProfile.message((String)"xmlui.EPerson.EditProfile.Language");
    private static final Message T_create_password_instructions = EditProfile.message((String)"xmlui.EPerson.EditProfile.create_password_instructions");
    private static final Message T_update_password_instructions = EditProfile.message((String)"xmlui.EPerson.EditProfile.update_password_instructions");
    private static final Message T_password = EditProfile.message((String)"xmlui.EPerson.EditProfile.password");
    private static final Message T_error_invalid_password = EditProfile.message((String)"xmlui.EPerson.EditProfile.error_invalid_password");
    private static final Message T_confirm_password = EditProfile.message((String)"xmlui.EPerson.EditProfile.confirm_password");
    private static final Message T_error_unconfirmed_password = EditProfile.message((String)"xmlui.EPerson.EditProfile.error_unconfirmed_password");
    private static final Message T_submit_update = EditProfile.message((String)"xmlui.EPerson.EditProfile.submit_update");
    private static final Message T_submit_create = EditProfile.message((String)"xmlui.EPerson.EditProfile.submit_create");
    private static final Message T_subscriptions = EditProfile.message((String)"xmlui.EPerson.EditProfile.subscriptions");
    private static final Message T_subscriptions_help = EditProfile.message((String)"xmlui.EPerson.EditProfile.subscriptions_help");
    private static final Message T_email_subscriptions = EditProfile.message((String)"xmlui.EPerson.EditProfile.email_subscriptions");
    private static final Message T_select_collection = EditProfile.message((String)"xmlui.EPerson.EditProfile.select_collection");
    private static final Message T_head_auth = EditProfile.message((String)"xmlui.EPerson.EditProfile.head_auth");
    private static final Message T_head_identify = EditProfile.message((String)"xmlui.EPerson.EditProfile.head_identify");
    private static final Message T_head_security = EditProfile.message((String)"xmlui.EPerson.EditProfile.head_security");
    private static Locale[] supportedLocales = EditProfile.getSupportedLocales();
    private String email;
    private boolean registering;
    private boolean allowSetPassword;
    private List<String> errors;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.email = parameters.getParameter("email", "unknown");
        this.registering = parameters.getParameterAsBoolean("registering", false);
        this.allowSetPassword = parameters.getParameterAsBoolean("allowSetPassword", false);
        String errors = parameters.getParameter("errors", "");
        this.errors = errors.length() > 0 ? Arrays.asList(errors.split(",")) : new ArrayList();
        if (this.eperson != null) {
            this.email = this.eperson.getEmail();
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        if (this.registering) {
            pageMeta.addMetadata("title").addContent(T_title_create);
        } else {
            pageMeta.addMetadata("title").addContent(T_title_update);
        }
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (this.registering) {
            pageMeta.addTrail().addContent(T_trail_new_registration);
        } else {
            pageMeta.addTrail().addContent(T_trail_update);
        }
    }

    public void addBody(Body body) throws WingException, SQLException {
        log.info((Object)LogManager.getHeader((Context)this.context, (String)"view_profile", (String)""));
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String defaultFirstName = "";
        String defaultLastName = "";
        String defaultPhone = "";
        String defaultLanguage = null;
        if (request.getParameter("submit") != null) {
            defaultFirstName = request.getParameter("first_name");
            defaultLastName = request.getParameter("last_name");
            defaultPhone = request.getParameter("phone");
            defaultLanguage = request.getParameter("language");
        } else if (this.eperson != null) {
            defaultFirstName = this.eperson.getFirstName();
            defaultLastName = this.eperson.getLastName();
            defaultPhone = this.eperson.getMetadata("phone");
            defaultLanguage = this.eperson.getLanguage();
        }
        String action = this.contextPath;
        action = this.registering ? action + "/register" : action + "/profile";
        Division profile = body.addInteractiveDivision("information", action, "post", "primary");
        if (this.registering) {
            profile.setHead(T_head_create);
        } else {
            profile.setHead(T_head_update);
        }
        if (this.registering) {
            EPersonUtils.registrationProgressList((Division)profile, (int)2);
        }
        org.dspace.app.xmlui.wing.element.List form = profile.addList("form", "form");
        org.dspace.app.xmlui.wing.element.List identity = form.addList("identity", "form");
        identity.setHead(T_head_identify);
        identity.addLabel(T_email_address);
        identity.addItem(this.email);
        Text firstName = identity.addItem().addText("first_name");
        firstName.setAutofocus("autofocus");
        firstName.setRequired();
        firstName.setLabel(T_first_name);
        firstName.setValue(defaultFirstName);
        if (this.errors.contains("first_name")) {
            firstName.addError(T_error_required);
        }
        if (!this.registering && !ConfigurationManager.getBooleanProperty((String)"xmlui.user.editmetadata", (boolean)true)) {
            firstName.setDisabled();
        }
        Text lastName = identity.addItem().addText("last_name");
        lastName.setRequired();
        lastName.setLabel(T_last_name);
        lastName.setValue(defaultLastName);
        if (this.errors.contains("last_name")) {
            lastName.addError(T_error_required);
        }
        if (!this.registering && !ConfigurationManager.getBooleanProperty((String)"xmlui.user.editmetadata", (boolean)true)) {
            lastName.setDisabled();
        }
        Text phone = identity.addItem().addText("phone");
        phone.setLabel(T_telephone);
        phone.setValue(defaultPhone);
        if (this.errors.contains("phone")) {
            phone.addError(T_error_required);
        }
        if (!this.registering && !ConfigurationManager.getBooleanProperty((String)"xmlui.user.editmetadata", (boolean)true)) {
            phone.setDisabled();
        }
        Select lang = identity.addItem().addSelect("language");
        lang.setLabel(T_language);
        if (supportedLocales.length > 0) {
            for (Locale lc : supportedLocales) {
                lang.addOption(lc.toString(), lc.getDisplayName());
            }
        } else {
            lang.addOption(I18nUtil.DEFAULTLOCALE.toString(), I18nUtil.DEFAULTLOCALE.getDisplayName());
        }
        lang.setOptionSelected(defaultLanguage == null || defaultLanguage.equals("") ? I18nUtil.DEFAULTLOCALE.toString() : defaultLanguage);
        if (!this.registering && !ConfigurationManager.getBooleanProperty((String)"xmlui.user.editmetadata", (boolean)true)) {
            lang.setDisabled();
        }
        if (!this.registering) {
            CollectionDropDown.CollectionPathEntry[] possibleEntries;
            org.dspace.app.xmlui.wing.element.List subscribe = form.addList("subscriptions", "form");
            subscribe.setHead(T_subscriptions);
            subscribe.addItem(T_subscriptions_help);
            Collection[] currentList = Subscribe.getSubscriptions((Context)this.context, (EPerson)this.context.getCurrentUser());
            Collection[] possibleList = Collection.findAll((Context)this.context);
            Select subscriptions = subscribe.addItem().addSelect("subscriptions");
            subscriptions.setLabel(T_email_subscriptions);
            subscriptions.setHelp("");
            subscriptions.enableAddOperation();
            subscriptions.enableDeleteOperation();
            subscriptions.addOption(-1, T_select_collection);
            for (CollectionDropDown.CollectionPathEntry collectionPathEntry : possibleEntries = CollectionDropDown.annotateWithPaths((Collection[])possibleList)) {
                subscriptions.addOption(collectionPathEntry.collection.getID(), collectionPathEntry.path);
            }
            for (CollectionDropDown.CollectionPathEntry collectionPathEntry : currentList) {
                subscriptions.addInstance().setOptionSelected(collectionPathEntry.getID());
            }
        }
        if (this.allowSetPassword) {
            org.dspace.app.xmlui.wing.element.List security = form.addList("security", "form");
            security.setHead(T_head_security);
            if (this.registering) {
                security.addItem().addContent(T_create_password_instructions);
            } else {
                security.addItem().addContent(T_update_password_instructions);
            }
            Password password = security.addItem().addPassword("password");
            password.setLabel(T_password);
            if (this.registering) {
                password.setRequired();
            }
            if (this.errors.contains("password")) {
                password.addError(T_error_invalid_password);
            }
            Password passwordConfirm = security.addItem().addPassword("password_confirm");
            passwordConfirm.setLabel(T_confirm_password);
            if (this.registering) {
                passwordConfirm.setRequired();
            }
            if (this.errors.contains("password_confirm")) {
                passwordConfirm.addError(T_error_unconfirmed_password);
            }
        }
        Button submit = form.addItem().addButton("submit");
        if (this.registering) {
            submit.setValue(T_submit_update);
        } else {
            submit.setValue(T_submit_create);
        }
        profile.addHidden("eperson-continue").setValue(this.knot.getId());
        if (!this.registering) {
            Group[] memberships = Group.allMemberGroups((Context)this.context, (EPerson)this.context.getCurrentUser());
            if (memberships.length <= 0) {
                return;
            }
            org.dspace.app.xmlui.wing.element.List list = profile.addList("memberships");
            list.setHead(T_head_auth);
            for (Group group : memberships) {
                list.addItem(group.getName());
            }
        }
    }

    public void recycle() {
        this.email = null;
        this.errors = null;
        super.recycle();
    }

    private static Locale[] getSupportedLocales() {
        String ll = ConfigurationManager.getProperty((String)"webui.supported.locales");
        if (ll != null) {
            return I18nUtil.parseLocales((String)ll);
        }
        Locale[] result = new Locale[]{I18nUtil.DEFAULTLOCALE};
        return result;
    }

    static {
        Arrays.sort(supportedLocales, new /* Unavailable Anonymous Inner Class!! */);
    }
}

