/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.itemexport.ItemExport;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_context_head = Navigation.message((String)"xmlui.administrative.Navigation.context_head");
    private static final Message T_context_edit_item = Navigation.message((String)"xmlui.administrative.Navigation.context_edit_item");
    private static final Message T_context_edit_collection = Navigation.message((String)"xmlui.administrative.Navigation.context_edit_collection");
    private static final Message T_context_item_mapper = Navigation.message((String)"xmlui.administrative.Navigation.context_item_mapper");
    private static final Message T_context_edit_community = Navigation.message((String)"xmlui.administrative.Navigation.context_edit_community");
    private static final Message T_context_create_collection = Navigation.message((String)"xmlui.administrative.Navigation.context_create_collection");
    private static final Message T_context_create_subcommunity = Navigation.message((String)"xmlui.administrative.Navigation.context_create_subcommunity");
    private static final Message T_context_create_community = Navigation.message((String)"xmlui.administrative.Navigation.context_create_community");
    private static final Message T_context_export_metadata = Navigation.message((String)"xmlui.administrative.Navigation.context_export_metadata");
    private static final Message T_administrative_batch_import = Navigation.message((String)"xmlui.administrative.Navigation.administrative_batch_import");
    private static final Message T_administrative_import_metadata = Navigation.message((String)"xmlui.administrative.Navigation.administrative_import_metadata");
    private static final Message T_administrative_head = Navigation.message((String)"xmlui.administrative.Navigation.administrative_head");
    private static final Message T_administrative_access_control = Navigation.message((String)"xmlui.administrative.Navigation.administrative_access_control");
    private static final Message T_administrative_people = Navigation.message((String)"xmlui.administrative.Navigation.administrative_people");
    private static final Message T_administrative_groups = Navigation.message((String)"xmlui.administrative.Navigation.administrative_groups");
    private static final Message T_administrative_authorizations = Navigation.message((String)"xmlui.administrative.Navigation.administrative_authorizations");
    private static final Message T_administrative_registries = Navigation.message((String)"xmlui.administrative.Navigation.administrative_registries");
    private static final Message T_administrative_metadata = Navigation.message((String)"xmlui.administrative.Navigation.administrative_metadata");
    private static final Message T_administrative_format = Navigation.message((String)"xmlui.administrative.Navigation.administrative_format");
    private static final Message T_administrative_content = Navigation.message((String)"xmlui.administrative.Navigation.administrative_content");
    private static final Message T_administrative_items = Navigation.message((String)"xmlui.administrative.Navigation.administrative_items");
    private static final Message T_administrative_withdrawn = Navigation.message((String)"xmlui.administrative.Navigation.administrative_withdrawn");
    private static final Message T_administrative_private = Navigation.message((String)"xmlui.administrative.Navigation.administrative_private");
    private static final Message T_administrative_control_panel = Navigation.message((String)"xmlui.administrative.Navigation.administrative_control_panel");
    private static final Message T_administrative_curation = Navigation.message((String)"xmlui.administrative.Navigation.administrative_curation");
    private static final Message T_statistics = Navigation.message((String)"xmlui.administrative.Navigation.statistics");
    private static final Message T_context_export_item = Navigation.message((String)"xmlui.administrative.Navigation.context_export_item");
    private static final Message T_context_export_collection = Navigation.message((String)"xmlui.administrative.Navigation.context_export_collection");
    private static final Message T_context_export_community = Navigation.message((String)"xmlui.administrative.Navigation.context_export_community");
    private static final Message T_account_export = Navigation.message((String)"xmlui.administrative.Navigation.account_export");
    private static final Message T_my_account = Navigation.message((String)"xmlui.EPerson.Navigation.my_account");
    private SourceValidity validity;
    List<String> availableExports = null;

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (request.getParameter("login_email") != null || request.getParameter("login_password") != null || request.getParameter("login_realm") != null) {
            return "0";
        }
        if (this.context.getCurrentUser() == null) {
            return Long.valueOf(HashUtil.hash((String)"anonymous"));
        }
        if (this.availableExports != null && this.availableExports.size() > 0) {
            StringBuilder key = new StringBuilder(this.context.getCurrentUser().getEmail());
            for (String fileName : this.availableExports) {
                key.append(":").append(fileName);
            }
            return Long.valueOf(HashUtil.hash((String)key.toString()));
        }
        return Long.valueOf(HashUtil.hash((String)this.context.getCurrentUser().getEmail()));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            if (this.context.getCurrentUser() != null) {
                try {
                    Group[] groups;
                    DSpaceValidity validity = new DSpaceValidity();
                    validity.add((DSpaceObject)this.eperson);
                    for (Group group : groups = Group.allMemberGroups((Context)this.context, (EPerson)this.eperson)) {
                        validity.add((DSpaceObject)group);
                    }
                    this.validity = validity.complete();
                }
                catch (SQLException sQLException) {}
            } else {
                this.validity = NOPValidity.SHARED_INSTANCE;
            }
        }
        return this.validity;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.availableExports = null;
        if (this.context.getCurrentUser() != null) {
            try {
                this.availableExports = ItemExport.getExportsAvailable((EPerson)this.context.getCurrentUser());
            }
            catch (Exception e) {
                throw new ProcessingException("Error getting available exports", (Throwable)e);
            }
        }
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        options.addList("browse");
        org.dspace.app.xmlui.wing.element.List account = options.addList("account");
        org.dspace.app.xmlui.wing.element.List context = options.addList("context");
        org.dspace.app.xmlui.wing.element.List admin = options.addList("administrative");
        account.setHead(T_my_account);
        if (this.availableExports != null && this.availableExports.size() > 0) {
            account.addItem().addXref(this.contextPath + "/admin/export", T_account_export);
        }
        boolean isSystemAdmin = AuthorizeManager.isAdmin((Context)this.context);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Item) {
            Item item = (Item)dso;
            if (item.canEdit()) {
                context.setHead(T_context_head);
                context.addItem().addXref(this.contextPath + "/admin/item?itemID=" + item.getID(), T_context_edit_item);
                if (AuthorizeManager.isAdmin((Context)this.context, (DSpaceObject)dso)) {
                    context.addItem().addXref(this.contextPath + "/admin/export?itemID=" + item.getID(), T_context_export_item);
                    context.addItem().addXref(this.contextPath + "/csv/handle/" + dso.getHandle(), T_context_export_metadata);
                }
            }
        } else if (dso instanceof Collection) {
            Collection collection = (Collection)dso;
            if (collection.canEditBoolean(true)) {
                context.setHead(T_context_head);
                context.addItemXref(this.contextPath + "/admin/collection?collectionID=" + collection.getID(), T_context_edit_collection);
                context.addItemXref(this.contextPath + "/admin/mapper?collectionID=" + collection.getID(), T_context_item_mapper);
                if (AuthorizeManager.isAdmin((Context)this.context, (DSpaceObject)dso)) {
                    context.addItem().addXref(this.contextPath + "/admin/export?collectionID=" + collection.getID(), T_context_export_collection);
                    context.addItem().addXref(this.contextPath + "/csv/handle/" + dso.getHandle(), T_context_export_metadata);
                }
            }
        } else if (dso instanceof Community) {
            Community community = (Community)dso;
            if (community.canEditBoolean()) {
                context.setHead(T_context_head);
                context.addItemXref(this.contextPath + "/admin/community?communityID=" + community.getID(), T_context_edit_community);
                if (AuthorizeManager.isAdmin((Context)this.context, (DSpaceObject)dso)) {
                    context.addItem().addXref(this.contextPath + "/admin/export?communityID=" + community.getID(), T_context_export_community);
                }
                context.addItem().addXref(this.contextPath + "/csv/handle/" + dso.getHandle(), T_context_export_metadata);
            }
            if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)community, (int)3)) {
                context.setHead(T_context_head);
                context.addItemXref(this.contextPath + "/admin/collection?createNew&communityID=" + community.getID(), T_context_create_collection);
                context.addItemXref(this.contextPath + "/admin/community?createNew&communityID=" + community.getID(), T_context_create_subcommunity);
            }
        }
        if (isSystemAdmin && ("community-list".equals(this.sitemapURI) || "".equals(this.sitemapURI))) {
            context.setHead(T_context_head);
            context.addItemXref(this.contextPath + "/admin/community?createNew", T_context_create_community);
        }
        if (isSystemAdmin) {
            admin.setHead(T_administrative_head);
            admin.addItemXref(this.contextPath + "/admin/panel", T_administrative_control_panel);
            org.dspace.app.xmlui.wing.element.List epeople = admin.addList("epeople");
            epeople.setHead(T_administrative_access_control);
            epeople.addItemXref(this.contextPath + "/admin/epeople", T_administrative_people);
            epeople.addItemXref(this.contextPath + "/admin/groups", T_administrative_groups);
            epeople.addItemXref(this.contextPath + "/admin/authorize", T_administrative_authorizations);
            org.dspace.app.xmlui.wing.element.List content = admin.addList("content");
            content.setHead(T_administrative_content);
            content.addItemXref(this.contextPath + "/admin/item", T_administrative_items);
            content.addItemXref(this.contextPath + "/admin/withdrawn", T_administrative_withdrawn);
            content.addItemXref(this.contextPath + "/admin/private", T_administrative_private);
            content.addItemXref(this.contextPath + "/admin/metadataimport", T_administrative_import_metadata);
            content.addItemXref(this.contextPath + "/admin/batchimport", T_administrative_batch_import);
            org.dspace.app.xmlui.wing.element.List registries = admin.addList("registries");
            registries.setHead(T_administrative_registries);
            registries.addItemXref(this.contextPath + "/admin/metadata-registry", T_administrative_metadata);
            registries.addItemXref(this.contextPath + "/admin/format-registry", T_administrative_format);
            admin.addItemXref(this.contextPath + "/statistics", T_statistics);
            admin.addItemXref(this.contextPath + "/admin/curate", T_administrative_curation);
        }
    }

    public int addContextualOptions(org.dspace.app.xmlui.wing.element.List context) throws SQLException, WingException {
        int options = 0;
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Item) {
            Item item = (Item)dso;
            if (item.canEdit()) {
                context.addItem().addXref(this.contextPath + "/admin/item?itemID=" + item.getID(), T_context_edit_item);
                ++options;
            }
        } else if (dso instanceof Collection) {
            Collection collection = (Collection)dso;
            if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)collection, (int)11)) {
                context.addItemXref(this.contextPath + "/admin/collection?collectionID=" + collection.getID(), T_context_edit_collection);
                context.addItemXref(this.contextPath + "/admin/mapper?collectionID=" + collection.getID(), T_context_item_mapper);
                ++options;
            }
        } else if (dso instanceof Community) {
            Community community = (Community)dso;
            if (community.canEditBoolean()) {
                context.addItemXref(this.contextPath + "/admin/community?communityID=" + community.getID(), T_context_edit_community);
                ++options;
            }
            if (AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)community, (int)3)) {
                context.addItemXref(this.contextPath + "/admin/collection?createNew&communityID=" + community.getID(), T_context_create_collection);
                context.addItemXref(this.contextPath + "/admin/community?createNew&communityID=" + community.getID(), T_context_create_subcommunity);
                ++options;
            }
        }
        if (("community-list".equals(this.sitemapURI) || "".equals(this.sitemapURI)) && AuthorizeManager.isAdmin((Context)this.context)) {
            context.addItemXref(this.contextPath + "/admin/community?createNew", T_context_create_community);
            ++options;
        }
        return options;
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

