/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.ByteRange;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

public class BitstreamReader
extends AbstractReader
implements Recyclable {
    private static Logger log = Logger.getLogger(BitstreamReader.class);
    private static final String AUTH_REQUIRED_HEADER = "xmlui.BitstreamReader.auth_header";
    private static final String AUTH_REQUIRED_MESSAGE = "xmlui.BitstreamReader.auth_message";
    protected static final int BUFFER_SIZE = 8192;
    protected static final int expires = 3600000;
    protected Response response;
    protected Request request;
    protected InputStream bitstreamInputStream;
    protected long bitstreamSize;
    protected String bitstreamMimeType;
    protected String bitstreamName;
    protected boolean isAnonymouslyReadable;
    private Item item = null;
    private boolean isSpider = false;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.request = ObjectModelHelper.getRequest((Map)objectModel);
            this.response = ObjectModelHelper.getResponse((Map)objectModel);
            boolean BitstreamReaderOpenedContext = !ContextUtil.isContextAvailable((Map)objectModel);
            Context context = ContextUtil.obtainContext((Map)objectModel);
            int itemID = par.getParameterAsInteger("itemID", -1);
            int bitstreamID = par.getParameterAsInteger("bitstreamID", -1);
            String handle = par.getParameter("handle", null);
            int sequence = par.getParameterAsInteger("sequence", -1);
            String name = par.getParameter("name", null);
            this.isSpider = par.getParameter("userAgent", "").equals("spider");
            Bitstream bitstream = null;
            DSpaceObject dso = null;
            if (bitstreamID > -1) {
                bitstream = Bitstream.find((Context)context, (int)bitstreamID);
            } else if (itemID > -1) {
                this.item = Item.find((Context)context, (int)itemID);
                if (sequence > -1) {
                    bitstream = this.findBitstreamBySequence(this.item, sequence);
                } else if (name != null) {
                    bitstream = this.findBitstreamByName(this.item, name);
                }
            } else if (handle != null && (dso = HandleManager.resolveToObject((Context)context, (String)handle)) instanceof Item) {
                this.item = (Item)dso;
                if (sequence > -1) {
                    bitstream = this.findBitstreamBySequence(this.item, sequence);
                } else if (name != null) {
                    bitstream = this.findBitstreamByName(this.item, name);
                }
            }
            if (sequence > -1 && bitstream == null && name != null && (bitstream = this.findBitstreamByName(this.item, name)) != null) {
                String redirectURL = "";
                redirectURL = this.item.getHandle() != null && this.item.getHandle().length() > 0 ? this.request.getContextPath() + "/bitstream/handle/" + this.item.getHandle() : this.request.getContextPath() + "/bitstream/item/" + this.item.getID();
                redirectURL = redirectURL + "/" + name + "?sequence=" + bitstream.getSequenceID();
                HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                httpResponse.sendRedirect(redirectURL);
                return;
            }
            if (bitstream == null) {
                throw new ResourceNotFoundException("Unable to locate bitstream");
            }
            boolean isAuthorized = AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)bitstream, (int)0);
            if (this.item != null && this.item.isWithdrawn() && !AuthorizeManager.isAdmin((Context)context)) {
                isAuthorized = false;
                log.info((Object)LogManager.getHeader((Context)context, (String)"view_bitstream", (String)("handle=" + this.item.getHandle() + ",withdrawn=true")));
            }
            String requestItemType = ConfigurationManager.getProperty((String)"request.item.type");
            if (!isAuthorized) {
                if (context.getCurrentUser() != null || StringUtils.equalsIgnoreCase((String)"all", (String)requestItemType)) {
                    String redictURL = this.request.getContextPath() + "/handle/";
                    if (this.item != null) {
                        redictURL = redictURL + this.item.getHandle();
                    } else if (dso != null) {
                        redictURL = redictURL + dso.getHandle();
                    }
                    redictURL = redictURL + "/restricted-resource?bitstreamId=" + bitstream.getID();
                    HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                    httpResponse.sendRedirect(redictURL);
                    return;
                }
                if (ConfigurationManager.getProperty((String)"request.item.type") == null || ConfigurationManager.getProperty((String)"request.item.type").equalsIgnoreCase("logged")) {
                    AuthenticationUtil.interruptRequest((Map)objectModel, (String)AUTH_REQUIRED_HEADER, (String)AUTH_REQUIRED_MESSAGE, null);
                    String redictURL = this.request.getContextPath() + "/login";
                    HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                    httpResponse.sendRedirect(redictURL);
                    return;
                }
            }
            this.bitstreamInputStream = bitstream.retrieve();
            this.bitstreamSize = bitstream.getSize();
            this.bitstreamMimeType = bitstream.getFormat().getMIMEType();
            this.bitstreamName = bitstream.getName();
            if (context.getCurrentUser() == null) {
                this.isAnonymouslyReadable = true;
            } else {
                this.isAnonymouslyReadable = false;
                for (ResourcePolicy rp : AuthorizeManager.getPoliciesActionFilter((Context)context, (DSpaceObject)bitstream, (int)0)) {
                    if (rp.getGroupID() != 0) continue;
                    this.isAnonymouslyReadable = true;
                }
            }
            if (this.bitstreamName != null && this.bitstreamName.length() > 0) {
                int finalSlashIndex = this.bitstreamName.lastIndexOf(47);
                if (finalSlashIndex > 0) {
                    this.bitstreamName = this.bitstreamName.substring(finalSlashIndex + 1);
                }
            } else {
                this.bitstreamName = "bitstream";
            }
            new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, (HttpServletRequest)ObjectModelHelper.getRequest((Map)objectModel), ContextUtil.obtainContext((HttpServletRequest)ObjectModelHelper.getRequest((Map)objectModel)), (DSpaceObject)bitstream));
            if (BitstreamReaderOpenedContext) {
                context.complete();
            }
        }
        catch (SQLException sqle) {
            throw new ProcessingException("Unable to read bitstream.", (Throwable)sqle);
        }
        catch (AuthorizeException ae) {
            throw new ProcessingException("Unable to read bitstream.", (Throwable)ae);
        }
    }

    private Bitstream findBitstreamBySequence(Item item, int sequence) throws SQLException {
        Bundle[] bundles;
        if (item == null) {
            return null;
        }
        for (Bundle bundle : bundles = item.getBundles()) {
            Bitstream[] bitstreams;
            for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                if (bitstream.getSequenceID() != sequence) continue;
                return bitstream;
            }
        }
        return null;
    }

    private Bitstream findBitstreamByName(Item item, String name) throws SQLException {
        if (name == null || item == null) {
            return null;
        }
        int maxDepthPathSearch = 3;
        if (ConfigurationManager.getProperty((String)"xmlui.html.max-depth-guess") != null) {
            maxDepthPathSearch = ConfigurationManager.getIntProperty((String)"xmlui.html.max-depth-guess");
        }
        for (int i = 0; i < maxDepthPathSearch + 1; ++i) {
            int indexOfLastSlash;
            Bundle[] bundles;
            for (Bundle bundle : bundles = item.getBundles()) {
                Bitstream[] bitstreams;
                for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                    if (!name.equals(bitstream.getName())) continue;
                    return bitstream;
                }
            }
            int indexOfSlash = name.indexOf(47);
            if (indexOfSlash < 0) {
                return null;
            }
            name = name.substring(indexOfSlash + 1);
            if (i != maxDepthPathSearch - 1 || (indexOfLastSlash = name.lastIndexOf(47)) <= -1) continue;
            name = name.substring(indexOfLastSlash + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        int threshold;
        long modSince;
        if (this.bitstreamInputStream == null) {
            return;
        }
        if (this.isSpider && (modSince = this.request.getDateHeader("If-Modified-Since")) != -1L && this.item != null && this.item.getLastModified().getTime() < modSince) {
            this.response.setStatus(304);
            return;
        }
        try {
            if (this.item != null && (this.isSpider || ContextUtil.obtainContext((HttpServletRequest)this.request).getCurrentUser() == null)) {
                this.response.setDateHeader("Last-Modified", this.item.getLastModified().getTime());
            }
        }
        catch (SQLException e) {
            throw new ProcessingException((Exception)e);
        }
        byte[] buffer = new byte[8192];
        int length = -1;
        if (this.isAnonymouslyReadable) {
            this.response.setDateHeader("Expires", System.currentTimeMillis() + 3600000L);
        }
        if (this.bitstreamSize > (long)(threshold = ConfigurationManager.getIntProperty((String)"xmlui.content_disposition_threshold")) && threshold != 0) {
            String name = this.bitstreamName;
            try {
                String agent = this.request.getHeader("USER-AGENT");
                if (agent != null && agent.contains("MSIE")) {
                    name = URLEncoder.encode(name, "UTF8");
                } else if (agent != null && agent.contains("Mozilla")) {
                    name = MimeUtility.encodeText((String)name, (String)"UTF8", (String)"B");
                }
            }
            catch (UnsupportedEncodingException see) {
                // empty catch block
            }
            this.response.setHeader("Content-Disposition", "attachment;filename=\"" + name + '\"');
        }
        Object byteRange = null;
        try {
            if (byteRange != null) {
                String entityRange;
                String entityLength;
                if (this.bitstreamSize != -1L) {
                    entityLength = "" + this.bitstreamSize;
                    entityRange = byteRange.intersection(new ByteRange(0L, this.bitstreamSize)).toString();
                } else {
                    entityLength = "*";
                    entityRange = byteRange.toString();
                }
                this.response.setHeader("Content-Range", entityRange + "/" + entityLength);
                if (this.response instanceof HttpResponse) {
                    this.response.setStatus(206);
                }
                int pos = 0;
                while ((length = this.bitstreamInputStream.read(buffer)) > -1) {
                    int posEnd = pos + length - 1;
                    ByteRange intersection = byteRange.intersection(new ByteRange((long)pos, (long)posEnd));
                    if (intersection != null) {
                        this.out.write(buffer, (int)intersection.getStart() - pos, (int)intersection.length());
                    }
                    pos += length;
                }
            } else {
                this.response.setHeader("Content-Length", String.valueOf(this.bitstreamSize));
                while ((length = this.bitstreamInputStream.read(buffer)) > -1) {
                    this.out.write(buffer, 0, length);
                }
                this.out.flush();
            }
        }
        finally {
            try {
                this.bitstreamInputStream.close();
                this.out.close();
            }
            catch (IOException ioe) {
                log.warn((Object)("Caught IO exception when closing a stream: " + ioe.getMessage()));
            }
        }
    }

    public String getMimeType() {
        return this.bitstreamMimeType;
    }

    public void recycle() {
        this.response = null;
        this.request = null;
        this.bitstreamInputStream = null;
        this.bitstreamSize = 0L;
        this.bitstreamMimeType = null;
    }
}

