/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;

public class VersionManager {
    private static final Message T_version_created = new Message("default", "The new version has been created.");
    private static final Message T_version_delete = new Message("default", "The selected version(s) have been deleted.");
    private static final Message T_version_updated = new Message("default", "The version has been updated.");
    private static final Message T_version_restored = new Message("default", "The version has been restored.");

    public static FlowResult processCreateNewVersion(Context context, int itemID, String summary) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        try {
            result.setContinue(false);
            Item item = Item.find((Context)context, (int)itemID);
            if (AuthorizeManager.isAdmin((Context)context, (DSpaceObject)item) || item.canEdit()) {
                VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
                Version version = versioningService.createNewVersion(context, itemID, summary);
                WorkspaceItem wsi = WorkspaceItem.findByItem((Context)context, (Item)version.getItem());
                context.commit();
                result.setParameter("wsid", (Object)wsi.getID());
                result.setOutcome(true);
                result.setContinue(true);
                result.setMessage(T_version_created);
                result.setParameter("summary", (Object)summary);
            }
        }
        catch (Exception ex) {
            context.abort();
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static FlowResult processUpdateVersion(Context context, int itemID, String summary) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        try {
            result.setContinue(false);
            Item item = Item.find((Context)context, (int)itemID);
            if (AuthorizeManager.isAdmin((Context)context, (DSpaceObject)item)) {
                VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
                versioningService.updateVersion(context, itemID, summary);
                context.commit();
                result.setOutcome(true);
                result.setContinue(true);
                result.setMessage(T_version_updated);
                result.setParameter("summary", (Object)summary);
            }
        }
        catch (Exception ex) {
            context.abort();
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static FlowResult processRestoreVersion(Context context, int versionID, String summary) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        try {
            result.setContinue(false);
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            versioningService.restoreVersion(context, versionID, summary);
            context.commit();
            result.setOutcome(true);
            result.setContinue(true);
            result.setMessage(T_version_restored);
        }
        catch (Exception ex) {
            context.abort();
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static FlowResult processDeleteVersions(Context context, int itemId, String[] versionIDs) throws SQLException, AuthorizeException, IOException, UIException {
        FlowResult result = new FlowResult();
        try {
            result.setContinue(false);
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            VersionHistory versionHistory = versioningService.findVersionHistory(context, itemId);
            for (String id : versionIDs) {
                versioningService.removeVersion(context, Integer.parseInt(id));
            }
            context.commit();
            Version latestVersion = versionHistory.getLatestVersion();
            if (latestVersion == null) {
                result.setParameter("itemID", null);
            } else {
                result.setParameter("itemID", (Object)latestVersion.getItemID());
            }
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_version_delete);
        }
        catch (Exception ex) {
            context.abort();
            throw new RuntimeException(ex);
        }
        return result;
    }
}

