/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.sql.SQLException;
import java.util.Map;
import java.util.Stack;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class HandleUtil {
    protected static final String HANDLE_PREFIX = "handle/";
    protected static final String DSPACE_OBJECT = "dspace.object";

    public static DSpaceObject obtainHandle(Map objectModel) throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        DSpaceObject dso = (DSpaceObject)request.getAttribute(DSPACE_OBJECT);
        if (dso == null) {
            String uri = request.getSitemapURI();
            if (!uri.startsWith(HANDLE_PREFIX)) {
                return null;
            }
            String handle = uri.substring(HANDLE_PREFIX.length());
            int firstSlash = handle.indexOf(47);
            if (firstSlash < 0) {
                return null;
            }
            int secondSlash = handle.indexOf(47, firstSlash + 1);
            if (secondSlash < 0) {
                secondSlash = handle.length();
            }
            handle = handle.substring(0, secondSlash);
            Context context = ContextUtil.obtainContext(objectModel);
            dso = HandleManager.resolveToObject((Context)context, (String)handle);
            request.setAttribute(DSPACE_OBJECT, (Object)dso);
        }
        return dso;
    }

    public static boolean inheritsFrom(DSpaceObject dso, String parent) throws SQLException {
        DSpaceObject current = dso;
        while (current != null) {
            if (current.getHandle().equals(parent)) {
                return true;
            }
            if (current.getType() == 2) {
                current = ((Item)current).getOwningCollection();
                continue;
            }
            if (current.getType() == 3) {
                current = ((Collection)current).getCommunities()[0];
                continue;
            }
            if (current.getType() != 4) continue;
            current = ((Community)current).getParentCommunity();
        }
        return false;
    }

    public static void buildHandleTrail(DSpaceObject dso, PageMeta pageMeta, String contextPath) throws SQLException, WingException {
        Collection collection;
        Stack<Object> stack = new Stack<Object>();
        if (dso instanceof Bitstream) {
            Bitstream bitstream = (Bitstream)dso;
            Bundle[] bundles = bitstream.getBundles();
            dso = bundles[0];
        }
        if (dso instanceof Bundle) {
            Bundle bundle = (Bundle)dso;
            Item[] items = bundle.getItems();
            dso = items[0];
        }
        if (dso instanceof Item) {
            Item item = (Item)dso;
            collection = item.getOwningCollection();
            dso = collection;
        }
        if (dso instanceof Collection) {
            Collection collection2 = (Collection)dso;
            stack.push(collection2);
            Community[] communities = collection2.getCommunities();
            dso = communities[0];
        }
        if (dso instanceof Community) {
            Community community = (Community)dso;
            stack.push(community);
            for (Community parent : community.getAllParents()) {
                stack.push(parent);
            }
        }
        while (!stack.empty()) {
            DSpaceObject pop = (DSpaceObject)stack.pop();
            if (pop instanceof Collection) {
                collection = (Collection)pop;
                String name = collection.getMetadata("name");
                if (name == null || name.length() == 0) {
                    pageMeta.addTrailLink(contextPath + "/handle/" + pop.getHandle(), new Message("default", "xmlui.general.untitled"));
                    continue;
                }
                pageMeta.addTrailLink(contextPath + "/handle/" + pop.getHandle(), name);
                continue;
            }
            if (!(pop instanceof Community)) continue;
            Community community = (Community)pop;
            String name = community.getMetadata("name");
            if (name == null || name.length() == 0) {
                pageMeta.addTrailLink(contextPath + "/handle/" + pop.getHandle(), new Message("default", "xmlui.general.untitled"));
                continue;
            }
            pageMeta.addTrailLink(contextPath + "/handle/" + pop.getHandle(), name);
        }
    }
}

